/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.AbstractNativeMojo;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE)
public class NativeBuildMojo
extends AbstractNativeMojo {
    private static final String NATIVE_IMAGE_META_INF = "META-INF/native-image";
    private static final String NATIVE_IMAGE_PROPERTIES_FILENAME = "native-image.properties";
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="mainClass")
    private String mainClass;
    @Parameter(property="imageName")
    private String imageName;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${mojoExecution}")
    private MojoExecution mojoExecution;
    private final List<Path> classpath = new ArrayList<Path>();
    private PluginParameterExpressionEvaluator evaluator;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping native-image generation (parameter 'skip' is true).");
            return;
        }
        this.evaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        this.classpath.clear();
        List<String> imageClasspathScopes = Arrays.asList("compile", "runtime");
        this.project.setArtifactFilter(artifact -> imageClasspathScopes.contains(artifact.getScope()));
        for (Artifact dependency : this.project.getArtifacts()) {
            this.addClasspath(dependency);
        }
        this.addClasspath(this.project.getArtifact());
        String classpathStr = this.classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        Path nativeImageExecutable = Utils.getNativeImage();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString(), "-cp", classpathStr);
            processBuilder.command().addAll(this.getBuildArgs());
            processBuilder.directory(this.getWorkingDirectory().toFile());
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    private void addClasspath(Artifact artifact) throws MojoExecutionException {
        if (!"jar".equals(artifact.getType())) {
            this.getLog().warn((CharSequence)("Ignoring non-jar type ImageClasspath Entry " + artifact));
            return;
        }
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            throw new MojoExecutionException("Missing jar-file for " + artifact + ". Ensure that" + this.plugin.getArtifactId() + " runs in package phase.");
        }
        Path jarFilePath = artifactFile.toPath();
        this.getLog().info((CharSequence)("ImageClasspath Entry: " + artifact + " (" + jarFilePath.toUri() + ")"));
        URI jarFileURI = URI.create("jar:" + jarFilePath.toUri());
        try (FileSystem jarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());){
            Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
            if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
                List nativeImageProperties = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith(NATIVE_IMAGE_PROPERTIES_FILENAME)).collect(Collectors.toList());
                for (Path nativeImageProperty : nativeImageProperties) {
                    Path relativeSubDir = nativeImageMetaInfBase.relativize(nativeImageProperty).getParent();
                    boolean valid = relativeSubDir != null && relativeSubDir.getNameCount() == 2;
                    valid = valid && relativeSubDir.getName(0).toString().equals(artifact.getGroupId());
                    if (valid = valid && relativeSubDir.getName(1).toString().equals(artifact.getArtifactId())) continue;
                    String example = "META-INF/native-image/${groupId}/${artifactId}/native-image.properties";
                    this.getLog().warn((CharSequence)(nativeImageProperty.toUri() + " does not match recommended " + example + " layout."));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Artifact " + artifact + "cannot be added to image classpath", (Exception)e);
        }
        this.classpath.add(jarFilePath);
    }

    private Path getWorkingDirectory() {
        this.outputDirectory.mkdirs();
        return this.outputDirectory.toPath();
    }

    private String consumeConfigurationNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        return this.getConfigurationNodeValue((ConfigurationContainer)selectedPlugin, nodeNames);
    }

    private String consumeExecutionsNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        for (PluginExecution execution : selectedPlugin.getExecutions()) {
            String value = this.getConfigurationNodeValue((ConfigurationContainer)execution, nodeNames);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getConfigurationNodeValue(ConfigurationContainer container, String ... nodeNames) {
        if (container != null && container.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom node = (Xpp3Dom)container.getConfiguration();
            for (String nodeName : nodeNames) {
                if ((node = node.getChild(nodeName)) != null) continue;
                return null;
            }
            String value = node.getValue();
            return this.evaluateValue(value);
        }
        return null;
    }

    private String evaluateValue(String value) {
        if (value != null) {
            try {
                Object evaluatedValue = this.evaluator.evaluate(value);
                if (evaluatedValue instanceof String) {
                    return (String)evaluatedValue;
                }
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void maybeSetMainClassFromPlugin(BiFunction<String, String[], String> mainClassProvider, String pluginName, String ... nodeNames) {
        if (this.mainClass == null) {
            this.mainClass = mainClassProvider.apply(pluginName, nodeNames);
            if (this.mainClass != null) {
                this.getLog().info((CharSequence)("Obtained main class from plugin " + pluginName + " with the following path: " + String.join((CharSequence)" -> ", nodeNames)));
            }
        }
    }

    private List<String> getBuildArgs() {
        this.maybeSetMainClassFromPlugin(this::consumeExecutionsNodeValue, "org.apache.maven.plugins:maven-shade-plugin", "transformers", "transformer", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-assembly-plugin", "archive", "manifest", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-jar-plugin", "archive", "manifest", "mainClass");
        ArrayList<String> list = new ArrayList<String>();
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            for (String buildArg : this.buildArgs) {
                list.addAll(Arrays.asList(buildArg.split("\\s+")));
            }
        }
        if (this.mainClass != null && !this.mainClass.equals(".")) {
            list.add("-H:Class=" + this.mainClass);
        }
        if (this.imageName == null) {
            this.imageName = this.project.getArtifactId();
        }
        list.add("-H:Name=" + this.imageName);
        return list;
    }
}

