/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.graalvm.buildtools.maven.sbom.ArtifactAdapter;
import org.graalvm.buildtools.maven.sbom.ArtifactToPackageNameResolver;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public final class SBOMGenerator {
    public static final int requiredNativeImageVersion = 24;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final BuildPluginManager pluginManager;
    private final RepositorySystem repositorySystem;
    private final String mainClass;
    private final Logger logger;
    private static final String SBOM_FILE_FORMAT = "json";
    private static final String SBOM_FILENAME_WITHOUT_EXTENSION = "base_sbom";
    private final String outputDirectory;
    public static final String SBOM_FILENAME = "base_sbom.json";

    public SBOMGenerator(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, RepositorySystem repositorySystem, String mainClass, Logger logger) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.repositorySystem = repositorySystem;
        this.mainClass = mainClass;
        this.logger = logger;
        this.outputDirectory = mavenProject.getBuild().getDirectory();
    }

    public static boolean checkAugmentedSBOMSupportedByJDKVersion(int detectedJdkVersion, boolean throwErrorIfNotSupported) throws IllegalArgumentException {
        if (detectedJdkVersion < 24) {
            if (throwErrorIfNotSupported) {
                throw new IllegalArgumentException(String.format("%s version %s is required to use configuration option %s but major JDK version %s has been detected.", "Oracle GraalVM", 24, "augmentedSBOM", detectedJdkVersion));
            }
            return false;
        }
        return true;
    }

    public void generate() throws MojoExecutionException {
        Path sbomPath = Paths.get(this.outputDirectory, SBOM_FILENAME);
        try {
            int loggingLevel = this.logger.getThreshold();
            this.logger.setThreshold(5);
            MojoExecutor.executeMojo((org.apache.maven.model.Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.cyclonedx"), (String)MojoExecutor.artifactId((String)"cyclonedx-maven-plugin"), (String)MojoExecutor.version((String)"2.8.1")), (String)MojoExecutor.goal((String)"makeAggregateBom"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputFormat"), (String)SBOM_FILE_FORMAT), MojoExecutor.element((String)MojoExecutor.name((String)"outputName"), (String)SBOM_FILENAME_WITHOUT_EXTENSION), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.outputDirectory), MojoExecutor.element((String)MojoExecutor.name((String)"skipNotDeployed"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"schemaVersion"), (String)"1.5")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            this.logger.setThreshold(loggingLevel);
            if (!Files.exists(sbomPath, new LinkOption[0])) {
                return;
            }
            ArtifactToPackageNameResolver resolver = new ArtifactToPackageNameResolver(this.mavenProject, this.repositorySystem, this.mavenSession.getRepositorySession(), this.mainClass);
            Set<ArtifactAdapter> artifacts = resolver.getArtifactAdapters();
            this.augmentSBOM(sbomPath, artifacts);
        }
        catch (Exception exception) {
            SBOMGenerator.deleteFileIfExists(sbomPath);
            String errorMsg = String.format("Failed to create SBOM. Please try again and report this issue if it persists. To bypass this failure, disable SBOM generation by setting configuration option %s to false.", "augmentedSBOM");
            throw new MojoExecutionException(errorMsg, exception);
        }
    }

    private static void deleteFileIfExists(Path sbomPath) {
        try {
            Files.deleteIfExists(sbomPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void augmentSBOM(Path baseSBOMPath, Set<ArtifactAdapter> artifacts) throws IOException {
        JSONObject metadataNode;
        JSONObject sbomJson = new JSONObject(Files.readString(baseSBOMPath));
        JSONArray componentsArray = sbomJson.optJSONArray("components");
        if (componentsArray != null) {
            componentsArray.forEach(componentNode -> this.augmentComponentNode((JSONObject)componentNode, artifacts));
        }
        if ((metadataNode = sbomJson.optJSONObject("metadata")) != null && metadataNode.has("component")) {
            this.augmentComponentNode(metadataNode.getJSONObject("component"), artifacts);
        }
        Files.writeString(baseSBOMPath, (CharSequence)sbomJson.toString(2), new OpenOption[0]);
    }

    private void augmentComponentNode(JSONObject componentNode, Set<ArtifactAdapter> artifactsWithPackageNames) {
        String groupField = "group";
        String nameField = "name";
        String versionField = "version";
        if (componentNode.has(groupField) && componentNode.has(nameField) && componentNode.has(versionField)) {
            String groupId = componentNode.getString(groupField);
            String artifactId = componentNode.getString(nameField);
            String version = componentNode.getString(versionField);
            Optional<ArtifactAdapter> optionalArtifact = artifactsWithPackageNames.stream().filter(artifact -> artifact.groupId.equals(groupId) && artifact.artifactId.equals(artifactId) && artifact.version.equals(version)).findFirst();
            if (optionalArtifact.isPresent()) {
                ArtifactAdapter artifact2 = optionalArtifact.get();
                JSONArray packageNamesArray = new JSONArray();
                List<String> sortedPackageNames = artifact2.packageNames.stream().sorted().collect(Collectors.toList());
                sortedPackageNames.forEach(arg_0 -> ((JSONArray)packageNamesArray).put(arg_0));
                componentNode.put("packageNames", (Object)packageNamesArray);
                String jarPath = "";
                if (artifact2.jarPath != null) {
                    jarPath = artifact2.jarPath.toString();
                }
                componentNode.put("jarPath", (Object)jarPath);
                componentNode.put("prunable", artifact2.prunable);
            }
        }
    }

    private static final class Plugin {
        static final String artifactId = "cyclonedx-maven-plugin";
        static final String groupId = "org.cyclonedx";
        static final String version = "2.8.1";
        static final String goal = "makeAggregateBom";

        private Plugin() {
        }

        private static final class Configuration {
            static final String outputFormat = "json";
            static final String outputName = "base_sbom";
            static final String skipNotDeployed = "false";
            static final String schemaVersion = "1.5";

            private Configuration() {
            }
        }
    }

    private static final class AddedComponentFields {
        static final String packageNames = "packageNames";
        static final String jarPath = "jarPath";
        static final String prunable = "prunable";

        private AddedComponentFields() {
        }
    }
}

