/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImageService;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.AgentCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.BaseNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.DefaultGraalVmExtension;
import org.graalvm.buildtools.gradle.internal.DeprecatedNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.GradleUtils;
import org.graalvm.buildtools.gradle.internal.ProcessGeneratedGraalResourceFiles;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.graalvm.buildtools.gradle.tasks.GenerateResourcesConfigFile;
import org.graalvm.buildtools.gradle.tasks.NativeRunTask;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GFileUtils;

public class NativeImagePlugin
implements Plugin<Project> {
    public static final String NATIVE_COMPILE_TASK_NAME = "nativeCompile";
    public static final String NATIVE_TEST_COMPILE_TASK_NAME = "nativeTestCompile";
    public static final String NATIVE_TEST_TASK_NAME = "nativeTest";
    public static final String NATIVE_TEST_EXTENSION = "test";
    public static final String NATIVE_MAIN_EXTENSION = "main";
    public static final String PROCESS_AGENT_RESOURCES_TASK_NAME = "filterAgentResources";
    public static final String PROCESS_AGENT_TEST_RESOURCES_TASK_NAME = "filterAgentTestResources";
    public static final String GENERATE_RESOURCES_CONFIG_FILE_TASK_NAME = "generateResourcesConfigFile";
    public static final String GENERATE_TEST_RESOURCES_CONFIG_FILE_TASK_NAME = "generateTestResourcesConfigFile";
    public static final String DEPRECATED_NATIVE_BUILD_EXTENSION = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_EXTENSION = "nativeTest";
    public static final String DEPRECATED_NATIVE_BUILD_TASK = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_BUILD_TASK = "nativeTestBuild";
    private static final Consumer<Object> FORCE_CONFIG = t -> {};
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private GraalVMLogger logger;

    @Inject
    public ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    public void apply(Project project) {
        Provider<NativeImageService> nativeImageServiceProvider = NativeImageService.registerOn(project);
        this.logger = GraalVMLogger.of(project.getLogger());
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaProject(project, nativeImageServiceProvider));
    }

    private void configureJavaProject(Project project, Provider<NativeImageService> nativeImageServiceProvider) {
        this.logger.log("====================");
        this.logger.log("Initializing project: " + project.getName());
        this.logger.log("====================");
        GraalVMExtension graalExtension = this.registerGraalVMExtension(project);
        NativeImageOptions mainOptions = NativeImagePlugin.createMainOptions(graalExtension, project);
        this.deprecateExtension(project, mainOptions, "nativeBuild", NATIVE_MAIN_EXTENSION);
        project.getPlugins().withId("application", p -> mainOptions.getMainClass().convention((Provider)((JavaApplication)project.getExtensions().findByType(JavaApplication.class)).getMainClass()));
        project.getPlugins().withId("java-library", p -> mainOptions.getSharedLibrary().convention((Object)true));
        NativeImagePlugin.registerServiceProvider(project, nativeImageServiceProvider);
        TaskContainer tasks = project.getTasks();
        Provider<Boolean> agent = NativeImagePlugin.agentPropertyOverride(project, mainOptions);
        TaskProvider imageBuilder = tasks.register(NATIVE_COMPILE_TASK_NAME, BuildNativeImageTask.class, builder -> {
            builder.getOptions().convention((Object)mainOptions);
            builder.getAgentEnabled().set(agent);
        });
        TaskProvider deprecatedTask = tasks.register("nativeBuild", t -> {
            t.dependsOn(new Object[]{imageBuilder});
            t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeBuild is deprecated. Use nativeCompile instead."));
        });
        tasks.register("nativeRun", NativeRunTask.class, task -> {
            task.getImage().convention(imageBuilder.map(t -> (RegularFile)t.getOutputFile().get()));
            task.getRuntimeArgs().convention(mainOptions.getRuntimeArgs());
        });
        this.configureClasspathJarFor(tasks, mainOptions, (TaskProvider<BuildNativeImageTask>)imageBuilder);
        TaskProvider<ProcessGeneratedGraalResourceFiles> processAgentFiles = NativeImagePlugin.registerProcessAgentFilesTask(project, PROCESS_AGENT_RESOURCES_TASK_NAME);
        project.getPlugins().withType(ApplicationPlugin.class, applicationPlugin -> {
            TaskProvider runTask = tasks.withType(JavaExec.class).named("run");
            runTask.configure(run -> NativeImagePlugin.configureAgent(project, agent, mainOptions, (TaskProvider<? extends JavaForkOptions>)runTask, processAgentFiles));
        });
        Provider generatedResourcesDir = project.getLayout().getBuildDirectory().dir("native/generated/");
        TaskProvider<GenerateResourcesConfigFile> generateResourcesConfig = this.registerResourcesConfigTask((Provider<Directory>)generatedResourcesDir, mainOptions, tasks, GradleUtils.transitiveProjectArtifacts(project, "runtimeClasspath"), GENERATE_RESOURCES_CONFIG_FILE_TASK_NAME);
        mainOptions.getConfigurationFileDirectories().from(new Object[]{generateResourcesConfig.map(t -> t.getOutputFile().map(f -> f.getAsFile().getParentFile()))});
        File testResultsDir = GradleUtils.getJavaPluginConvention(project).getTestResultsDir();
        DirectoryProperty testListDirectory = project.getObjects().directoryProperty();
        NativeImageOptions testOptions = NativeImagePlugin.createTestOptions(graalExtension, project, mainOptions, testListDirectory);
        this.deprecateExtension(project, testOptions, "nativeTest", NATIVE_TEST_EXTENSION);
        TaskCollection<Test> testTask = NativeImagePlugin.findTestTask(project);
        Provider<Boolean> testAgent = NativeImagePlugin.agentPropertyOverride(project, testOptions);
        TaskProvider<ProcessGeneratedGraalResourceFiles> processAgentTestFiles = NativeImagePlugin.registerProcessAgentFilesTask(project, PROCESS_AGENT_TEST_RESOURCES_TASK_NAME);
        TaskProvider<GenerateResourcesConfigFile> generateTestResourcesConfig = this.registerResourcesConfigTask((Provider<Directory>)generatedResourcesDir, testOptions, tasks, GradleUtils.transitiveProjectArtifacts(project, "testRuntimeClasspath"), GENERATE_TEST_RESOURCES_CONFIG_FILE_TASK_NAME);
        testOptions.getConfigurationFileDirectories().from(new Object[]{generateTestResourcesConfig.map(t -> t.getOutputFile().map(f -> f.getAsFile().getParentFile()))});
        testTask.configureEach(test -> {
            testListDirectory.set(new File(testResultsDir, test.getName() + "/testlist"));
            test.getOutputs().dir((Object)testResultsDir);
            test.systemProperty(JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR, testListDirectory.getAsFile().get());
            NativeImagePlugin.configureAgent(project, testAgent, testOptions, (TaskProvider<? extends JavaForkOptions>)testTask.named(test.getName()), processAgentTestFiles);
            test.doFirst("cleanup test ids", (Action)new CleanupTestIdsDirectory(testListDirectory));
        });
        NativeImagePlugin.injectTestPluginDependencies(project);
        TaskProvider testImageBuilder = tasks.register(NATIVE_TEST_COMPILE_TASK_NAME, BuildNativeImageTask.class, task -> {
            task.setDescription("Builds native image with tests.");
            task.getOptions().set((Object)testOptions);
            testTask.forEach(FORCE_CONFIG);
            ConfigurableFileCollection testList = project.getObjects().fileCollection();
            testList.from(new Object[]{testListDirectory}).builtBy(new Object[]{testTask});
            testOptions.getClasspath().from(new Object[]{testList});
            task.getAgentEnabled().set(testAgent);
        });
        tasks.register(DEPRECATED_NATIVE_TEST_BUILD_TASK, t -> {
            t.dependsOn(new Object[]{imageBuilder});
            t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeTestBuild is deprecated. Use nativeTestCompile instead."));
        });
        this.configureClasspathJarFor(tasks, testOptions, (TaskProvider<BuildNativeImageTask>)testImageBuilder);
        tasks.register("nativeTest", NativeRunTask.class, task -> {
            task.setDescription("Runs native-image compiled tests.");
            task.setGroup("verification");
            task.getImage().convention(testImageBuilder.map(t -> (RegularFile)t.getOutputFile().get()));
            task.getRuntimeArgs().convention(testOptions.getRuntimeArgs());
        });
    }

    private void deprecateExtension(Project project, NativeImageOptions delegate, String name, String substitute) {
        JavaToolchainService toolchains = (JavaToolchainService)project.getExtensions().findByType(JavaToolchainService.class);
        ObjectFactory objects = project.getObjects();
        project.getExtensions().add(name, objects.newInstance(DeprecatedNativeImageOptions.class, new Object[]{name, delegate, substitute, project.getLogger()}));
    }

    private void configureClasspathJarFor(TaskContainer tasks, NativeImageOptions options, TaskProvider<BuildNativeImageTask> imageBuilder) {
        String baseName = imageBuilder.getName();
        TaskProvider classpathJar = tasks.register(baseName + "ClasspathJar", Jar.class, jar -> {
            jar.from(new Object[]{options.getClasspath().getElements().map(elems -> elems.stream().map(e -> this.getArchiveOperations().zipTree(e)).collect(Collectors.toList()))});
            jar.setDuplicatesStrategy(DuplicatesStrategy.WARN);
            jar.getArchiveBaseName().set((Object)(baseName.toLowerCase(Locale.ENGLISH) + "-classpath"));
        });
        imageBuilder.configure(nit -> {
            if (((Boolean)options.getUseFatJar().get()).booleanValue()) {
                nit.getClasspathJar().set(classpathJar.flatMap(AbstractArchiveTask::getArchiveFile));
            }
        });
    }

    private GraalVMExtension registerGraalVMExtension(Project project) {
        NamedDomainObjectContainer nativeImages = project.getObjects().domainObjectContainer(NativeImageOptions.class, name -> (BaseNativeImageOptions)project.getObjects().newInstance(BaseNativeImageOptions.class, new Object[]{name, project.getObjects(), project.getProviders(), project.getExtensions().findByType(JavaToolchainService.class), project.getName()}));
        return (GraalVMExtension)project.getExtensions().create(GraalVMExtension.class, "graalvmNative", DefaultGraalVmExtension.class, new Object[]{nativeImages});
    }

    private TaskProvider<GenerateResourcesConfigFile> registerResourcesConfigTask(Provider<Directory> generatedDir, NativeImageOptions options, TaskContainer tasks, FileCollection transitiveProjectArtifacts, String name) {
        return tasks.register(name, GenerateResourcesConfigFile.class, task -> {
            task.setDescription("Generates a GraalVM resource-config.json file");
            task.getOptions().convention((Object)options.getResources());
            task.getClasspath().from(new Object[]{options.getClasspath()});
            task.getTransitiveProjectArtifacts().from(new Object[]{transitiveProjectArtifacts});
            task.getOutputFile().convention(generatedDir.map(d -> d.file(name + "/resource-config.json")));
        });
    }

    private static Provider<Boolean> agentPropertyOverride(Project project, NativeImageOptions extension) {
        return project.getProviders().gradleProperty("agent").forUseAtConfigurationTime().map(v -> {
            if (!v.isEmpty()) {
                return Boolean.valueOf(v);
            }
            return true;
        }).orElse(extension.getAgent());
    }

    private static TaskProvider<ProcessGeneratedGraalResourceFiles> registerProcessAgentFilesTask(Project project, String name) {
        return project.getTasks().register(name, ProcessGeneratedGraalResourceFiles.class, task -> {
            task.getFilterableEntries().convention(Arrays.asList("org.gradle.", "java."));
            task.getOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("native/processed/agent/" + name));
        });
    }

    private static TaskCollection<Test> findTestTask(Project project) {
        return project.getTasks().withType(Test.class).matching(task -> NATIVE_TEST_EXTENSION.equals(task.getName()));
    }

    private static void registerServiceProvider(Project project, Provider<NativeImageService> nativeImageServiceProvider) {
        project.getTasks().withType(BuildNativeImageTask.class).configureEach(task -> {
            task.usesService(nativeImageServiceProvider);
            task.getService().set(nativeImageServiceProvider);
        });
    }

    private static NativeImageOptions createMainOptions(GraalVMExtension graalExtension, Project project) {
        NativeImageOptions buildExtension = (NativeImageOptions)graalExtension.getBinaries().create(NATIVE_MAIN_EXTENSION);
        buildExtension.getClasspath().from(new Object[]{GradleUtils.findMainArtifacts(project)});
        buildExtension.getClasspath().from(new Object[]{GradleUtils.findConfiguration(project, "runtimeClasspath")});
        return buildExtension;
    }

    private static NativeImageOptions createTestOptions(GraalVMExtension graalExtension, Project project, NativeImageOptions mainExtension, DirectoryProperty testListDirectory) {
        NativeImageOptions testExtension = (NativeImageOptions)graalExtension.getBinaries().create(NATIVE_TEST_EXTENSION);
        testExtension.getMainClass().set((Object)"org.graalvm.junit.platform.NativeImageJUnitLauncher");
        testExtension.getMainClass().finalizeValue();
        testExtension.getImageName().convention(mainExtension.getImageName().map(name -> name + "-tests"));
        ListProperty<String> runtimeArgs = testExtension.getRuntimeArgs();
        runtimeArgs.add((Object)"--xml-output-dir");
        runtimeArgs.add(project.getLayout().getBuildDirectory().dir("test-results/test-native").map(d -> d.getAsFile().getAbsolutePath()));
        testExtension.buildArgs("--features=org.graalvm.junit.platform.JUnitPlatformFeature");
        testExtension.getBuildArgs().add(project.provider(() -> "-Djunit.platform.listeners.uid.tracking.output.dir=" + ((File)testListDirectory.getAsFile().get()).getAbsolutePath()));
        ConfigurableFileCollection classpath = testExtension.getClasspath();
        classpath.from(new Object[]{GradleUtils.findMainArtifacts(project)});
        classpath.from(new Object[]{GradleUtils.findConfiguration(project, "testRuntimeClasspath")});
        classpath.from(new Object[]{GradleUtils.findSourceSet(project, NATIVE_TEST_EXTENSION).getOutput().getClassesDirs()});
        classpath.from(new Object[]{GradleUtils.findSourceSet(project, NATIVE_TEST_EXTENSION).getOutput().getResourcesDir()});
        return testExtension;
    }

    private static void configureAgent(Project project, Provider<Boolean> agent, NativeImageOptions nativeImageOptions, TaskProvider<? extends JavaForkOptions> instrumentedTask, TaskProvider<ProcessGeneratedGraalResourceFiles> postProcessingTask) {
        AgentCommandLineProvider cliProvider = (AgentCommandLineProvider)project.getObjects().newInstance(AgentCommandLineProvider.class, new Object[0]);
        cliProvider.getEnabled().set(agent);
        Provider outputDir = project.getLayout().getBuildDirectory().dir("native/agent-output/" + instrumentedTask.getName());
        cliProvider.getOutputDirectory().set(outputDir);
        ((JavaForkOptions)((Task)instrumentedTask.get())).getJvmArgumentProviders().add(cliProvider);
        ((ProcessGeneratedGraalResourceFiles)((Object)postProcessingTask.get())).getGeneratedFilesDir().set(instrumentedTask.map(t -> (Directory)outputDir.get()));
        ConfigurableFileCollection files = project.getObjects().fileCollection();
        files.from(new Object[]{agent.map(enabled -> enabled != false ? postProcessingTask : project.files(new Object[0]))});
        files.builtBy(new Object[]{() -> (Boolean)agent.get() != false ? (Task)postProcessingTask.get() : null});
        nativeImageOptions.getConfigurationFileDirectories().from(new Object[]{files});
    }

    private static void injectTestPluginDependencies(Project project) {
        project.getDependencies().add("implementation", (Object)"org.graalvm.buildtools:junit-platform-native:0.9.5");
    }

    private static final class CleanupTestIdsDirectory
    implements Action<Task> {
        private final DirectoryProperty directory;

        private CleanupTestIdsDirectory(DirectoryProperty directory) {
            this.directory = directory;
        }

        public void execute(Task task) {
            File dir = (File)this.directory.getAsFile().get();
            if (dir.exists()) {
                GFileUtils.deleteDirectory((File)dir);
            }
        }
    }
}

