/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageCommandLineProvider;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class BuildNativeImageTask
extends DefaultTask {
    private final Provider<String> graalvmHomeProvider;

    @Nested
    public abstract Property<NativeImageOptions> getOptions();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    protected abstract DirectoryProperty getWorkingDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Optional
    @Input
    protected Provider<String> getGraalVMHome() {
        return this.graalvmHomeProvider;
    }

    @Internal
    public Provider<String> getExecutableName() {
        return this.getOptions().flatMap(NativeImageOptions::getImageName);
    }

    @Internal
    public Provider<RegularFile> getOutputFile() {
        return this.getOutputDirectory().map(dir -> (RegularFile)dir.file(this.getExecutableName()).get());
    }

    @Input
    public abstract Property<Boolean> getAgentEnabled();

    @Inject
    protected abstract ProviderFactory getProviders();

    @InputFile
    @Optional
    public abstract RegularFileProperty getClasspathJar();

    public BuildNativeImageTask() {
        DirectoryProperty buildDir = this.getProject().getLayout().getBuildDirectory();
        Provider outputDir = buildDir.dir("native/" + this.getName());
        this.getWorkingDirectory().set(outputDir);
        this.setDescription("Builds a native image.");
        this.setGroup("build");
        this.getOptions().convention(this.getProject().getExtensions().findByType(NativeImageOptions.class));
        this.getOutputDirectory().convention(outputDir);
        this.graalvmHomeProvider = this.getProject().getProviders().environmentVariable("GRAALVM_HOME");
    }

    private List<String> buildActualCommandLineArgs() {
        this.getOptions().finalizeValue();
        return new NativeImageCommandLineProvider((Provider<NativeImageOptions>)this.getOptions(), (Provider<Boolean>)this.getAgentEnabled(), this.getExecutableName(), (Provider<String>)this.getProviders().provider(() -> ((File)this.getOutputDirectory().getAsFile().get()).getAbsolutePath()), (Provider<RegularFile>)this.getClasspathJar()).asArguments();
    }

    @Internal
    public abstract Property<Object> getService();

    @TaskAction
    public void exec() {
        JavaInstallationMetadata metadata;
        File executablePath;
        List<String> args = this.buildActualCommandLineArgs();
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        GraalVMLogger logger = GraalVMLogger.of(this.getLogger());
        if (((Boolean)options.getVerbose().get()).booleanValue()) {
            logger.lifecycle("Args are: " + args);
        }
        if (!(executablePath = (metadata = ((JavaLauncher)options.getJavaLauncher().get()).getMetadata()).getInstallationPath().file("bin/" + SharedConstants.NATIVE_IMAGE_EXE).getAsFile()).exists() && this.getGraalVMHome().isPresent()) {
            executablePath = Paths.get((String)this.getGraalVMHome().get(), new String[0]).resolve("bin").resolve(SharedConstants.NATIVE_IMAGE_EXE).toFile();
        }
        try {
            if (!executablePath.exists()) {
                logger.log("Native Image executable wasn't found. We will now try to download it. ");
                File graalVmHomeGuess = executablePath.getParentFile();
                if (!graalVmHomeGuess.toPath().resolve(SharedConstants.GU_EXE).toFile().exists()) {
                    throw new GradleException("'" + SharedConstants.GU_EXE + "' tool wasn't found. This probably means that JDK at isn't a GraalVM distribution.");
                }
                ExecResult res = this.getExecOperations().exec(spec -> {
                    spec.args(new Object[]{"install", "native-image"});
                    spec.setExecutable((Object)Paths.get(graalVmHomeGuess.getAbsolutePath(), SharedConstants.GU_EXE));
                });
                if (res.getExitValue() != 0) {
                    throw new GradleException("Native Image executable wasn't found, and '" + SharedConstants.GU_EXE + "' tool failed to install it.");
                }
            }
        }
        catch (GradleException e) {
            throw new GradleException("Determining GraalVM installation failed with message: " + e.getMessage() + "\n\nMake sure to declare the GRAALVM_HOME environment variable or install GraalVM with native-image in a standard location recognized by Gradle Java toolchain support");
        }
        logger.log("Using executable path: " + executablePath);
        String executable = executablePath.getAbsolutePath();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            this.getExecOperations().exec(spec -> {
                spec.setWorkingDir((Object)this.getWorkingDirectory());
                spec.args((Iterable)args);
                this.getService().get();
                spec.setExecutable(executable);
            });
            logger.lifecycle("Native Image written to: " + outputDir);
        }
    }
}

