/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;

public class NativeImageCommandLineProvider
implements CommandLineArgumentProvider {
    private static final Transformer<Boolean, Boolean> NEGATE = b -> b == false;
    private final Provider<NativeImageOptions> options;
    private final Provider<String> executableName;
    private final Provider<String> outputDirectory;
    private final Provider<String> workingDirectory;
    private final Provider<RegularFile> classpathJar;
    private final Provider<Boolean> useArgFile;

    public NativeImageCommandLineProvider(Provider<NativeImageOptions> options, Provider<String> executableName, Provider<String> workingDirectory, Provider<String> outputDirectory, Provider<RegularFile> classpathJar, Provider<Boolean> useArgFile) {
        this.options = options;
        this.executableName = executableName;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.classpathJar = classpathJar;
        this.useArgFile = useArgFile;
    }

    @Nested
    public Provider<NativeImageOptions> getOptions() {
        return this.options;
    }

    @Input
    public Provider<String> getExecutableName() {
        return this.executableName;
    }

    @Input
    public Provider<String> getOutputDirectory() {
        return this.outputDirectory;
    }

    @InputFile
    public Provider<RegularFile> getClasspathJar() {
        return this.classpathJar;
    }

    public List<String> asArguments() {
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        ArrayList<String> cliArgs = new ArrayList<String>(20);
        cliArgs.addAll((Collection)options.getExcludeConfigArgs().get());
        cliArgs.add("-cp");
        String classpathString = this.buildClasspathString(options);
        cliArgs.add(classpathString);
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getDebug(), "-g");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getFallback().map(NEGATE), "--no-fallback");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getVerbose(), "--verbose");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getSharedLibrary(), "--shared");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getQuickBuild(), "-Ob");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getRichOutput(), "-H:+BuildOutputColorful");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getPgoInstrument(), "--pgo-instrument");
        if (this.getOutputDirectory().isPresent()) {
            cliArgs.add("-H:Path=" + (String)this.getOutputDirectory().get());
        }
        cliArgs.add("-H:Name=" + (String)this.getExecutableName().get());
        ((Map)options.getSystemProperties().get()).forEach((n, v) -> {
            if (v != null) {
                cliArgs.add("-D" + n + "=\"" + v + "\"");
            }
        });
        ((List)options.getJvmArgs().get()).forEach(jvmArg -> cliArgs.add("-J" + jvmArg));
        String configFiles = ((Set)options.getConfigurationFileDirectories().getElements().get()).stream().map(FileSystemLocation::getAsFile).map(File::getAbsolutePath).collect(Collectors.joining(","));
        if (!configFiles.isEmpty()) {
            cliArgs.add("-H:ConfigurationFileDirectories=" + configFiles);
        }
        if (options.getMainClass().isPresent()) {
            cliArgs.add("-H:Class=" + (String)options.getMainClass().get());
        }
        if (Boolean.FALSE.equals(options.getPgoInstrument().get()) && options.getPgoProfilesDirectory().isPresent()) {
            FileTree files = ((Directory)options.getPgoProfilesDirectory().get()).getAsFileTree();
            Set profiles = files.filter(f -> f.getName().endsWith(".iprof")).getFiles();
            for (File profile : profiles) {
                cliArgs.add("--pgo=" + profile);
            }
        }
        cliArgs.addAll((Collection)options.getBuildArgs().get());
        if (((Boolean)this.useArgFile.getOrElse((Object)true)).booleanValue()) {
            Path argFileDir = Paths.get((String)this.workingDirectory.get(), new String[0]);
            return NativeImageUtils.convertToArgsFile(cliArgs, (Path)argFileDir, (Path)argFileDir);
        }
        return Collections.unmodifiableList(cliArgs);
    }

    protected String buildClasspathString(NativeImageOptions options) {
        String classpathString = this.classpathJar.isPresent() ? ((RegularFile)this.classpathJar.get()).getAsFile().getAbsolutePath() : options.getClasspath().getAsPath();
        return classpathString;
    }

    private static void appendBooleanOption(List<String> cliArgs, Provider<Boolean> provider, String whenTrue) {
        if (((Boolean)provider.get()).booleanValue()) {
            cliArgs.add(whenTrue);
        }
    }
}

