/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.nio.file.Paths;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public class NativeImageExecutableLocator {
    public static Provider<String> graalvmHomeProvider(ProviderFactory providers) {
        return providers.environmentVariable("GRAALVM_HOME").forUseAtConfigurationTime().orElse(providers.environmentVariable("JAVA_HOME").forUseAtConfigurationTime());
    }

    public static File findNativeImageExecutable(Property<JavaLauncher> javaLauncher, Provider<Boolean> disableToolchainDetection, Provider<String> graalvmHomeProvider, ExecOperations execOperations, GraalVMLogger logger) {
        JavaInstallationMetadata metadata;
        File executablePath = null;
        if ((((Boolean)disableToolchainDetection.get()).booleanValue() || !javaLauncher.isPresent()) && graalvmHomeProvider.isPresent()) {
            String graalvmHome = (String)graalvmHomeProvider.get();
            logger.lifecycle("Toolchain detection is disabled, will use GraalVM from {}.", graalvmHome);
            executablePath = Paths.get(graalvmHome, new String[0]).resolve("bin/" + SharedConstants.NATIVE_IMAGE_EXE).toFile();
        }
        if (executablePath == null && !(executablePath = (metadata = ((JavaLauncher)javaLauncher.get()).getMetadata()).getInstallationPath().file("bin/" + SharedConstants.NATIVE_IMAGE_EXE).getAsFile()).exists() && graalvmHomeProvider.isPresent()) {
            executablePath = Paths.get((String)graalvmHomeProvider.get(), new String[0]).resolve("bin").resolve(SharedConstants.NATIVE_IMAGE_EXE).toFile();
        }
        try {
            if (!executablePath.exists()) {
                logger.log("Native Image executable wasn't found. We will now try to download it. ");
                File graalVmHomeGuess = executablePath.getParentFile();
                if (!graalVmHomeGuess.toPath().resolve(SharedConstants.GU_EXE).toFile().exists()) {
                    throw new GradleException("'" + SharedConstants.GU_EXE + "' tool wasn't found. This probably means that JDK at isn't a GraalVM distribution.");
                }
                ExecResult res = execOperations.exec(spec -> {
                    spec.args(new Object[]{"install", "native-image"});
                    spec.setExecutable((Object)Paths.get(graalVmHomeGuess.getAbsolutePath(), SharedConstants.GU_EXE));
                });
                if (res.getExitValue() != 0) {
                    throw new GradleException("Native Image executable wasn't found, and '" + SharedConstants.GU_EXE + "' tool failed to install it.");
                }
            }
        }
        catch (GradleException e) {
            throw new GradleException("Determining GraalVM installation failed with message: " + e.getMessage() + "\n\nMake sure to declare the GRAALVM_HOME environment variable or install GraalVM with native-image in a standard location recognized by Gradle Java toolchain support");
        }
        return executablePath;
    }
}

