/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.dsl.agent.AgentOptions;
import org.graalvm.buildtools.gradle.internal.DefaultTestBinaryConfig;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class DefaultGraalVmExtension
implements GraalVMExtension {
    private final transient NamedDomainObjectContainer<NativeImageOptions> nativeImages;
    private final transient NativeImagePlugin plugin;
    private final transient Project project;
    private final Property<JavaLauncher> defaultJavaLauncher;

    @Inject
    public DefaultGraalVmExtension(NamedDomainObjectContainer<NativeImageOptions> nativeImages, NativeImagePlugin plugin, Project project) {
        this.nativeImages = nativeImages;
        this.plugin = plugin;
        this.project = project;
        this.defaultJavaLauncher = project.getObjects().property(JavaLauncher.class);
        this.getToolchainDetection().convention((Object)false);
        nativeImages.configureEach(options -> options.getJavaLauncher().convention(this.defaultJavaLauncher));
        this.getTestSupport().convention((Object)true);
        AgentOptions agentOpts = this.getAgent();
        agentOpts.getDefaultMode().convention((Object)"standard");
        agentOpts.getEnabled().convention((Object)false);
        agentOpts.getModes().getConditional().getParallel().convention((Object)true);
        agentOpts.getMetadataCopy().getMergeWithExisting().convention((Object)false);
        agentOpts.getBuiltinHeuristicFilter().convention((Object)true);
        agentOpts.getBuiltinCallerFilter().convention((Object)true);
        agentOpts.getEnableExperimentalPredefinedClasses().convention((Object)false);
        agentOpts.getEnableExperimentalUnsafeAllocationTracing().convention((Object)true);
        agentOpts.getTrackReflectionMetadata().convention((Object)true);
        this.configureToolchain();
    }

    private void configureToolchain() {
        this.defaultJavaLauncher.convention(this.getToolchainDetection().flatMap(enabled -> {
            JavaToolchainService toolchainService;
            if (enabled.booleanValue() && (toolchainService = (JavaToolchainService)this.project.getExtensions().findByType(JavaToolchainService.class)) != null) {
                return toolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)JavaVersion.current().getMajorVersion())));
            }
            return null;
        }));
    }

    @Override
    public NamedDomainObjectContainer<NativeImageOptions> getBinaries() {
        return this.nativeImages;
    }

    @Override
    public void agent(Action<? super AgentOptions> spec) {
        spec.execute((Object)this.getAgent());
    }

    @Override
    public void binaries(Action<? super NamedDomainObjectContainer<NativeImageOptions>> spec) {
        spec.execute(this.nativeImages);
    }

    @Override
    public void registerTestBinary(String name, Action<? super GraalVMExtension.TestBinaryConfig> spec) {
        DefaultTestBinaryConfig config = (DefaultTestBinaryConfig)this.project.getObjects().newInstance(DefaultTestBinaryConfig.class, new Object[]{name});
        spec.execute((Object)config);
        this.plugin.registerTestBinary(this.project, this, config);
    }
}

