/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;

public class GradleUtils {
    private static final GradleVersion MINIMAL_GRADLE_VERSION = GradleVersion.version((String)"7.4");

    public static SourceSet findSourceSet(Project project, String sourceSetName) {
        SourceSetContainer sourceSetContainer = GradleUtils.getJavaPluginConvention(project).getSourceSets();
        return (SourceSet)sourceSetContainer.findByName(sourceSetName);
    }

    public static JavaPluginExtension getJavaPluginConvention(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }

    public static Configuration findConfiguration(Project project, String name) {
        return project.getConfigurations().getByName(name);
    }

    public static FileCollection transitiveProjectArtifacts(Project project, String name) {
        ConfigurableFileCollection transitiveProjectArtifacts = project.getObjects().fileCollection();
        transitiveProjectArtifacts.from(new Object[]{GradleUtils.findMainArtifacts(project)});
        transitiveProjectArtifacts.from(new Object[]{GradleUtils.findConfiguration(project, name).getIncoming().artifactView(view -> view.componentFilter(ProjectComponentIdentifier.class::isInstance)).getFiles()});
        return transitiveProjectArtifacts;
    }

    public static FileCollection findMainArtifacts(Project project) {
        return GradleUtils.findConfiguration(project, "runtimeElements").getOutgoing().getArtifacts().getFiles();
    }

    public static Provider<Integer> intProperty(ProviderFactory providers, String propertyName, int defaultValue) {
        return GradleUtils.stringProperty(providers, propertyName).map(Integer::parseInt).orElse((Object)defaultValue);
    }

    private static Provider<String> stringProperty(ProviderFactory providers, String propertyName) {
        return providers.systemProperty(propertyName).orElse(providers.gradleProperty(propertyName)).orElse(providers.environmentVariable(propertyName.replace('.', '_').toUpperCase()));
    }
}

