/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.logging.Logger;

public final class GraalVMLogger {
    private static final Set<String> LOGGED_MESSAGES = new HashSet<String>();
    private final Logger delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newBuild() {
        Set<String> set = LOGGED_MESSAGES;
        synchronized (set) {
            LOGGED_MESSAGES.clear();
        }
    }

    public static GraalVMLogger of(Logger delegate) {
        return new GraalVMLogger(delegate);
    }

    private GraalVMLogger(Logger delegate) {
        this.delegate = delegate;
    }

    public void log(String s) {
        this.delegate.info("[native-image-plugin] {}", (Object)s);
    }

    public void log(String pattern, Object ... args) {
        this.delegate.info("[native-image-plugin] " + pattern, args);
    }

    public void lifecycle(String s) {
        this.delegate.lifecycle("[native-image-plugin] {}", new Object[]{s});
    }

    public void lifecycle(String pattern, Object ... args) {
        this.delegate.lifecycle("[native-image-plugin] " + pattern, args);
    }

    public void error(String s) {
        this.delegate.error("[native-image-plugin] {}", (Object)s);
    }

    public void warn(String s) {
        this.delegate.warn("[native-image-plugin] {}", (Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnce(String message) {
        Set<String> set = LOGGED_MESSAGES;
        synchronized (set) {
            if (LOGGED_MESSAGES.add(message)) {
                this.lifecycle(message);
            }
        }
    }
}

