/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Executable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.junit.platform.NativeImageConfigurationImpl;
import org.graalvm.junit.platform.TestClassRegistrar;
import org.graalvm.junit.platform.config.core.PluginConfigProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnitPlatformFeature
implements Feature {
    public final boolean debug = System.getProperty("debug") != null;
    private static final NativeImageConfigurationImpl nativeImageConfigImpl = new NativeImageConfigurationImpl();
    private final ServiceLoader<PluginConfigProvider> extensionConfigProviders = ServiceLoader.load(PluginConfigProvider.class);

    public static void debug(String format, Object ... args) {
        if (JUnitPlatformFeature.debug()) {
            System.out.printf("[Debug] " + format + "%n", args);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.extensionConfigProviders.forEach(p -> p.initialize(access.getApplicationClassLoader(), nativeImageConfigImpl));
    }

    private static boolean debug() {
        return ((JUnitPlatformFeature)ImageSingletons.lookup(JUnitPlatformFeature.class)).debug;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.forEachProvider(p -> p.onLoad(nativeImageConfigImpl));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Runtime.version().feature() <= 21) {
            JUnitPlatformFeature.initializeClassesForJDK21OrEarlier();
        }
        List<? extends DiscoverySelector> selectors = this.getSelectors();
        this.registerTestClassesForReflection(selectors);
        JUnitPlatformFeature.registerClassesForHamcrestSupport(access);
    }

    private List<? extends DiscoverySelector> getSelectors() {
        try {
            String uniqueIdDirectoryProperty = System.getProperty("junit.platform.listeners.uid.tracking.output.dir");
            if (uniqueIdDirectoryProperty == null) {
                throw new IllegalStateException("Cannot determine test-ids directory because junit.platform.listeners.uid.tracking.output.dir property is null");
            }
            String uniqueIdFilePrefix = System.getProperty("junit.platform.listeners.uid.tracking.output.file.prefix", "junit-platform-unique-ids");
            if (uniqueIdFilePrefix == null) {
                throw new IllegalStateException("Cannot determine unique test-ids prefix because junit.platform.listeners.uid.tracking.output.file.prefix property is null");
            }
            Path uniqueIdDirectory = Path.of(uniqueIdDirectoryProperty, new String[0]);
            List selectors = this.readAllFiles(uniqueIdDirectory, uniqueIdFilePrefix).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
            if (!selectors.isEmpty()) {
                System.out.printf("[junit-platform-native] Running in 'test listener' mode using files matching pattern [%s*] found in folder [%s] and its subfolders.%n", uniqueIdFilePrefix, uniqueIdDirectory.toAbsolutePath());
                return selectors;
            }
        }
        catch (Exception ex) {
            JUnitPlatformFeature.debug("Failed to read UIDs from UniqueIdTrackingListener output files: " + ex.getMessage(), new Object[0]);
        }
        throw new RuntimeException("Cannot compute test selectors from test ids.");
    }

    private void registerTestClassesForReflection(List<? extends DiscoverySelector> selectors) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
        TestClassRegistrar testClassRegistrar = new TestClassRegistrar(clazz -> {
            JUnitPlatformFeature.debug("Registering test class for reflection: %s", clazz.getName());
            nativeImageConfigImpl.registerAllClassMembersForReflection((Class<?>)clazz);
            this.forEachProvider(p -> p.onTestClassRegistered((Class<?>)clazz, nativeImageConfigImpl));
        });
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = launcher.discover(request);
        testPlan.getRoots().stream().flatMap(rootIdentifier -> testPlan.getDescendants(rootIdentifier).stream()).map(TestIdentifier::getSource).filter(Optional::isPresent).map(Optional::get).filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getJavaClass).forEach(testClassRegistrar::registerTestClassForReflection);
    }

    private void forEachProvider(Consumer<PluginConfigProvider> consumer) {
        for (PluginConfigProvider provider : this.extensionConfigProviders) {
            consumer.accept(provider);
        }
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return JUnitPlatformFeature.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }

    private static void registerClassesForHamcrestSupport(Feature.BeforeAnalysisAccess access) {
        ClassLoader applicationLoader = access.getApplicationClassLoader();
        Class<?> typeSafeMatcher = JUnitPlatformFeature.findClassOrNull(applicationLoader, "org.hamcrest.TypeSafeMatcher");
        Class<?> typeSafeDiagnosingMatcher = JUnitPlatformFeature.findClassOrNull(applicationLoader, "org.hamcrest.TypeSafeDiagnosingMatcher");
        if (typeSafeMatcher != null || typeSafeDiagnosingMatcher != null) {
            BiConsumer<Feature.DuringAnalysisAccess, Class> registerMatcherForReflection = (a, c) -> RuntimeReflection.register((Executable[])c.getDeclaredMethods());
            if (typeSafeMatcher != null) {
                access.registerSubtypeReachabilityHandler(registerMatcherForReflection, typeSafeMatcher);
            }
            if (typeSafeDiagnosingMatcher != null) {
                access.registerSubtypeReachabilityHandler(registerMatcherForReflection, typeSafeDiagnosingMatcher);
            }
        }
    }

    private static Class<?> findClassOrNull(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static void initializeClassesForJDK21OrEarlier() {
        block13: {
            try (InputStream is = JUnitPlatformFeature.class.getResourceAsStream("/initialize-at-buildtime");){
                if (is == null) break block13;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                    br.lines().forEach(cls -> {
                        try {
                            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{cls});
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process build time initializations for JDK 21 or earlier");
            }
        }
    }
}

