/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public class DirectoryConfiguration {
    private static final String PROPERTIES = "reachability-metadata.properties";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Path directory;
    private final boolean override;

    public DirectoryConfiguration(String groupId, String artifactId, String version, Path directory, boolean override) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.directory = directory;
        this.override = override;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public static void copy(Collection<DirectoryConfiguration> configurations, Path destinationDirectory) throws IOException {
        Path nativeImageDestination = destinationDirectory.resolve("META-INF").resolve("native-image");
        for (DirectoryConfiguration configuration : configurations) {
            Path target = nativeImageDestination.resolve(configuration.groupId).resolve(configuration.artifactId).resolve(configuration.version != null ? configuration.version : configuration.getDirectory().getFileName().toString());
            DirectoryConfiguration.copyFileTree(configuration.directory, target);
            DirectoryConfiguration.writeConfigurationProperties(configuration, target);
        }
    }

    private static void copyFileTree(final Path source, final Path target) throws IOException {
        if (Files.notExists(source, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(directory)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!"index.json".equalsIgnoreCase(file.getFileName().toString())) {
                    Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void writeConfigurationProperties(DirectoryConfiguration configuration, Path target) throws IOException {
        if (Files.notExists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        StringBuilder content = new StringBuilder();
        if (configuration.isOverride()) {
            content.append("override=true\n");
        }
        if (content.length() > 0) {
            Files.write(target.resolve(PROPERTIES), content.toString().getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        }
    }
}

