/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.services.impl;

import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.alerts.AlertStorage;
import org.apache.tapestry5.alerts.Duration;
import org.apache.tapestry5.alerts.Severity;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.ajax.JavaScriptCallback;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.services.JGrowlManager;

public class JGrowlManagerImpl
implements JGrowlManager {
    private final ApplicationStateManager asm;
    private final Request request;
    private final AjaxResponseRenderer ajaxResponseRenderer;
    private final PerThreadValue<Boolean> needAlertStorageCleanup;

    public JGrowlManagerImpl(ApplicationStateManager asm, Request request, AjaxResponseRenderer ajaxResponseRenderer, PerthreadManager perThreadManager) {
        this.asm = asm;
        this.request = request;
        this.ajaxResponseRenderer = ajaxResponseRenderer;
        this.needAlertStorageCleanup = perThreadManager.createValue();
    }

    public void success(String message) {
        this.alert(Duration.SINGLE, Severity.SUCCESS, message);
    }

    public void info(String message) {
        this.alert(Duration.SINGLE, Severity.INFO, message);
    }

    public void warn(String message) {
        this.alert(Duration.SINGLE, Severity.WARN, message);
    }

    public void error(String message) {
        this.alert(Duration.SINGLE, Severity.ERROR, message);
    }

    public void alert(Duration duration, Severity severity, String message) {
        Alert alert = new Alert(duration, severity, message);
        if (this.request.isXHR()) {
            this.addCallbackForAlert(alert);
        }
        this.getAlertStorage().add(alert);
    }

    private void addCallbackForAlert(final Alert alert) {
        this.ajaxResponseRenderer.addCallback(new JavaScriptCallback(){

            public void run(JavaScriptSupport javascriptSupport) {
                javascriptSupport.require("tjq/jgrowl").with(new Object[]{alert.toJSON()});
            }
        });
        this.addAlertStorageCleanupCallback();
    }

    private void addAlertStorageCleanupCallback() {
        if (((Boolean)this.needAlertStorageCleanup.get((Object)true)).booleanValue()) {
            this.ajaxResponseRenderer.addCallback(new JavaScriptCallback(){

                public void run(JavaScriptSupport javascriptSupport) {
                    JGrowlManagerImpl.this.getAlertStorage().dismissNonPersistent();
                }
            });
            this.needAlertStorageCleanup.set((Object)false);
        }
    }

    private AlertStorage getAlertStorage() {
        return (AlertStorage)this.asm.get(AlertStorage.class);
    }
}

