/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.mixins;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.data.ContextMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Import(stylesheet={"${jquery.assets.root}/vendor/mixins/contextmenu/jquery.contextMenu.css"})
public class ContextMenu {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Parameter(required=true)
    @Property
    private List<ContextMenuItem> items;
    @Parameter(defaultPrefix="literal", value="right")
    @Property
    private String trigger;
    @Parameter(defaultPrefix="literal", value="200")
    @Property
    private int delay;
    @Parameter(defaultPrefix="literal", value="false")
    @Property
    private boolean autoHide;
    @Parameter(defaultPrefix="literal", value="1")
    @Property
    private int zIndex;
    @Parameter
    private Object[] context;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;
    @InjectContainer
    private ClientElement element;

    @AfterRender
    public void afterRender() {
        JSONObject config = new JSONObject();
        String clientId = this.element.getClientId();
        config.put("id", (Object)clientId);
        config.put("trigger", (Object)this.trigger);
        config.put("delay", (Object)this.delay);
        config.put("autoHide", (Object)this.autoHide);
        config.put("zIndex", (Object)this.zIndex);
        JSONObject jsonItems = new JSONObject();
        int sepKeySuffix = 1;
        JSONArray keys = new JSONArray();
        for (ContextMenuItem item : this.items) {
            if (item.getIsSeparator()) {
                keys.put((Object)("sep" + sepKeySuffix));
                jsonItems.put("sep" + sepKeySuffix, (Object)"---------");
                ++sepKeySuffix;
                continue;
            }
            Link link = this.resources.createEventLink(item.event, this.context);
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("name", (Object)item.label);
            jsonItem.put("icon", (Object)item.icon);
            jsonItem.put("url", (Object)link.toAbsoluteURI());
            keys.put((Object)item.event);
            jsonItems.put(item.event, (Object)jsonItem);
        }
        config.put("items", (Object)jsonItems);
        config.put("keys", (Object)keys);
        if (this.resources.isBound("zone")) {
            this.log.debug("Zone is bound to {}", (Object)this.zone);
            config.put("zone", (Object)this.zone);
        }
        this.javaScriptSupport.require("tjq/contextmenu").with(new Object[]{config});
    }
}

