/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.components.TextField;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class RangeSlider {
    @Parameter(required=true)
    private Object min;
    @Parameter
    private Object[] context;
    @Parameter(required=true)
    private Object max;
    @Parameter
    private JSONObject params;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter(value="false")
    private boolean displayTextField;
    private JSONObject specs;
    @Parameter(value="false")
    @Property(write=false)
    private boolean disableTextfields;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport jsSupport;
    @Component
    private TextField maxField;
    @Component
    private TextField minField;
    private String clientId;

    private String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.jsSupport.allocateClientId(this.resources);
        }
        return this.clientId;
    }

    @SetupRender
    void startDiv(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        this.resources.renderInformalParameters(writer);
        writer.end();
        this.specs = new JSONObject();
        if (!this.resources.isBound("params")) {
            this.params = new JSONObject();
        }
        this.params.put("range", (Object)true);
        this.specs.put("params", (Object)this.params);
        this.specs.put("sliderId", (Object)this.getSliderId());
        this.specs.put("displayTextField", (Object)this.displayTextField);
        this.specs.put("idMinField", (Object)this.minField.getClientId());
        this.specs.put("idMaxField", (Object)this.maxField.getClientId());
        if (this.resources.isBound("zone")) {
            Link link = this.resources.createEventLink("action", this.context);
            this.specs.put("url", (Object)link.toAbsoluteURI());
            this.specs.put("zoneId", (Object)this.zone);
        }
        this.jsSupport.require("tjq/rangeSlider").with(new Object[]{this.specs});
    }

    public String getSliderId() {
        return this.getClientId() + "-slider";
    }

    public String getDisplayTextField() {
        return this.displayTextField ? "" : "display:none;";
    }
}

