/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.alerts.AlertStorage;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.base.BaseClientElement;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;

@Import(stylesheet={"${jquery.assets.root}/vendor/components/jgrowl/jquery.jgrowl.css"})
public class JGrowl
extends BaseClientElement {
    @Parameter
    private JSONObject params;
    @Parameter(value="message:core-dismiss-label", defaultPrefix="literal")
    private String dismissText;
    @SessionState(create=false)
    private AlertStorage storage;
    @Inject
    private DeprecationWarning deprecationWarning;

    void onPageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, new String[]{"dismissText"});
    }

    boolean beginRender(MarkupWriter writer) {
        Link dismissLink = this.resources.createEventLink("dismiss", new Object[0]);
        this.storeElement(writer.element("div", new Object[]{"data-container-type", "alerts", "data-dismiss-url", dismissLink}));
        this.resources.renderInformalParameters(writer);
        writer.end();
        this.addAlertsFromStorage();
        return false;
    }

    Object onDismiss(@RequestParameter(value="id", allowBlank=true) Long alertId) {
        if (this.storage != null) {
            if (alertId != null) {
                this.storage.dismiss(alertId.longValue());
            } else {
                this.storage.dismissAll();
            }
        }
        return new JSONObject();
    }

    @HeartbeatDeferred
    void addAlertsFromStorage() {
        if (this.storage == null) {
            return;
        }
        for (Alert alert : this.storage.getAlerts()) {
            this.javaScriptSupport.require("tjq/jgrowl").with(new Object[]{alert.toJSON()});
        }
        this.storage.dismissNonPersistent();
    }
}

