/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import javax.inject.Inject;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@Import(stylesheet={"${jquery.assets.root}/vendor/components/jcrop/jquery.Jcrop.css"})
@SupportsInformalParameters
public class ImageCropper
implements ClientElement {
    @Environmental
    private JavaScriptSupport _support;
    @Inject
    private ComponentResources _resources;
    @Parameter(defaultPrefix="literal")
    private String _src;
    @Parameter(defaultPrefix="literal", value="context")
    private String _domain;
    @Parameter(defaultPrefix="asset")
    private Asset asset;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter(defaultPrefix="prop")
    private JSONObject options;
    @Inject
    private AssetSource assetSource;
    @Inject
    private ComponentResources cr;

    @BeginRender
    void begin(MarkupWriter writer) {
        String clientId = this._support.allocateClientId(this._resources.getId());
        Asset image = this.asset;
        if (!this._resources.isBound("asset")) {
            image = this.assetSource.getAsset(null, this._domain + ":" + this._src, null);
        }
        writer.element("img", new Object[]{"src", image.toClientURL(), "id", clientId});
        if (this.cr.isBound("zone")) {
            writer.attributes(new Object[]{"data-update-zone", this.zone});
        }
        this._resources.renderInformalParameters(writer);
    }

    @BeforeRenderBody
    boolean beforeRenderBody() {
        return false;
    }

    @AfterRender
    void after(MarkupWriter writer) {
        writer.end();
        JSONObject jso = new JSONObject();
        jso.put("id", (Object)this.clientId);
        if (this._resources.isBound("zone")) {
            Link link = this._resources.createEventLink("selected", new Object[0]);
            jso.put("url", (Object)link.toAbsoluteURI());
            jso.put("zoneId", (Object)this.zone);
        }
        JQueryUtils.merge(jso, this.options);
        this._support.require("tjq/imagecropper").with(new Object[]{jso});
    }

    public String getClientId() {
        return this.clientId;
    }
}

