/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.corelib.data.GridPagerPosition;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.beaneditor.BeanModelUtils;
import org.apache.tapestry5.internal.bindings.AbstractBinding;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.TranslatorSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.internal.TableInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportsInformalParameters
public class AbstractTable
implements ClientElement {
    @Parameter(required=true, autoconnect=true)
    private GridDataSource source;
    @Parameter(value="top", defaultPrefix="literal")
    private GridPagerPosition pagerPosition;
    @Parameter
    private BeanModel model;
    @Parameter(value="25")
    private int rowsPerPage;
    @Parameter
    private GridSortModel sortModel;
    @Parameter(defaultPrefix="literal")
    private String add;
    @Parameter(value="this", allowNull=false)
    private PropertyOverrides overrides;
    @Parameter(defaultPrefix="literal")
    private String include;
    @Parameter(defaultPrefix="literal")
    private String exclude;
    @Parameter(defaultPrefix="literal")
    private String reorder;
    @Parameter
    private Object value;
    @Parameter
    private boolean inPlace;
    @Parameter(required=false)
    private Object row;
    @Parameter
    private int rowIndex;
    @Parameter(cache=false)
    private String rowClass;
    @Property
    @Parameter(cache=false)
    private int columnIndex;
    @Parameter(defaultPrefix="prop")
    private TableInformation tableInformation;
    private BeanModel dataModel;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private BeanModelSource modelSource;
    @Inject
    private TranslatorSource translatorSource;
    @Persist
    private Boolean sortAscending;
    @Persist
    private String sortColumnId;
    private String clientId;
    @Property
    private Integer index;
    @Property
    private String cellModel;
    @Inject
    private TypeCoercer typeCoercer;
    @Inject
    private Request request;
    @Inject
    private Block cell;

    @SetupRender
    void resetClientId() {
        this.clientId = null;
    }

    public String getClientId() {
        if (InternalUtils.isBlank((String)this.clientId)) {
            this.clientId = InternalUtils.isNonBlank((String)((String)this.resources.getInformalParameter("id", String.class))) ? (String)this.resources.getInformalParameter("id", String.class) : this.javaScriptSupport.allocateClientId(this.resources);
        }
        return this.clientId;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public GridSortModel getSortModel() {
        return this.sortModel;
    }

    public boolean getSortAscending() {
        return this.sortAscending != null && this.sortAscending != false;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public BeanModel getModel() {
        return this.model;
    }

    public BeanModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = this.getModel();
            BeanModelUtils.modify((BeanModel)this.dataModel, (String)this.add, (String)this.include, (String)this.exclude, (String)this.reorder);
        }
        return this.dataModel;
    }

    public GridDataSource getSource() {
        return this.source;
    }

    GridSortModel defaultSortModel() {
        return new DefaultGridSortModel();
    }

    public PropertyOverrides getOverrides() {
        return this.overrides;
    }

    protected Binding defaultModel() {
        return new AbstractBinding(){

            public Object get() {
                GridDataSource gridDataSource = AbstractTable.this.getSource();
                Class rowType = gridDataSource.getRowType();
                if (rowType == null) {
                    throw new RuntimeException(String.format("Unable to determine the bean type for rows from %s. You should bind the model parameter explicitly.", gridDataSource));
                }
                return AbstractTable.this.modelSource.createDisplayModel(rowType, AbstractTable.this.overrides.getOverrideMessages());
            }

            public boolean isInvariant() {
                return false;
            }
        };
    }

    public String getRowClass() {
        List classes = CollectionFactory.newList();
        String rc = this.rowClass;
        if (rc != null) {
            classes.add(rc);
        }
        return TapestryInternalUtils.toClassAttributeValue((List)classes);
    }

    public Object getCellValue() {
        Object obj = this.getSource().getRowValue(this.index.intValue());
        if (obj == null) {
            return "";
        }
        PropertyConduit conduit = this.getDataModel().get(this.cellModel).getConduit();
        Class type = conduit.getPropertyType();
        Object val = conduit.get(obj);
        if (val == null) {
            return "";
        }
        if (!String.class.equals(this.getDataModel().get(this.cellModel).getClass()) && !Number.class.isAssignableFrom(this.getDataModel().get(this.cellModel).getClass())) {
            Translator translator = this.translatorSource.findByType(this.getDataModel().get(this.cellModel).getPropertyType());
            val = translator != null ? translator.toClient(val) : val.toString();
        }
        return val;
    }

    public List<String> getPropertyNames() {
        return this.getDataModel().getPropertyNames();
    }

    public Iterable<Integer> getLoopSource() {
        int startIndex = 0;
        int endIndex = this.getSource().getAvailableRows() - 1;
        this.getSource().prepare(startIndex, endIndex, this.sortModel.getSortConstraints());
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    Integer i = new Integer(0);

                    @Override
                    public boolean hasNext() {
                        return this.i < AbstractTable.this.getSource().getAvailableRows();
                    }

                    @Override
                    public Integer next() {
                        AbstractTable.this.row = AbstractTable.this.getSource().getRowValue(this.i.intValue());
                        Integer n = this.i;
                        Integer n2 = this.i = Integer.valueOf(this.i + 1);
                        return n;
                    }

                    @Override
                    public void remove() {
                        this.i = 0;
                    }
                };
            }
        };
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Block getCellBlock() {
        this.rowIndex = this.index;
        Block override = this.overrides.getOverrideBlock(this.getDataModel().get(this.cellModel).getPropertyName() + "Cell");
        if (override != null) {
            return override;
        }
        return this.cell;
    }

    public TableInformation getTableInformation() {
        return this.tableInformation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachingDataSource
    implements GridDataSource {
        private final GridDataSource delegate;
        private boolean availableRowsCached;
        private int availableRows;

        CachingDataSource(GridDataSource delegate) {
            this.delegate = delegate;
        }

        public int getAvailableRows() {
            if (!this.availableRowsCached) {
                this.availableRows = this.delegate.getAvailableRows();
                this.availableRowsCached = true;
            }
            return this.availableRows;
        }

        public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
            this.delegate.prepare(startIndex, endIndex, sortConstraints);
        }

        public Object getRowValue(int index) {
            return this.delegate.getRowValue(index);
        }

        public Class getRowType() {
            return this.delegate.getRowType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultGridSortModel
    implements GridSortModel {
        DefaultGridSortModel() {
        }

        public ColumnSort getColumnSort(String columnId) {
            if (!TapestryInternalUtils.isEqual((Object)columnId, (Object)AbstractTable.this.sortColumnId)) {
                return ColumnSort.UNSORTED;
            }
            return this.getColumnSort();
        }

        private ColumnSort getColumnSort() {
            return AbstractTable.this.getSortAscending() ? ColumnSort.ASCENDING : ColumnSort.DESCENDING;
        }

        public void updateSort(String columnId) {
            assert (InternalUtils.isNonBlank((String)columnId));
            if (columnId.equals(AbstractTable.this.sortColumnId)) {
                AbstractTable.this.setSortAscending(!AbstractTable.this.getSortAscending());
                return;
            }
            AbstractTable.this.sortColumnId = columnId;
            AbstractTable.this.setSortAscending(true);
        }

        public List<SortConstraint> getSortConstraints() {
            if (AbstractTable.this.sortColumnId == null) {
                return Collections.emptyList();
            }
            PropertyModel sortModel = AbstractTable.this.getDataModel().getById(AbstractTable.this.sortColumnId);
            SortConstraint constraint = new SortConstraint(sortModel, this.getColumnSort());
            return Collections.singletonList(constraint);
        }

        public void clear() {
            AbstractTable.this.sortColumnId = null;
        }
    }
}

