/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glowroot.agent.bytecode.api.MessageTemplate;
import org.glowroot.agent.plugin.api.MethodInfo;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Accessor;
import org.glowroot.agent.weaving.Beans;

public class MessageTemplateImpl
implements MessageTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MessageTemplateImpl.class);
    private static final Pattern pattern = Pattern.compile("\\{\\{([^}]*)}}");
    private final ImmutableList<Part> allParts;
    private final ImmutableList<ValuePathPart> thisPathParts;
    private final ImmutableList<ArgPathPart> argPathParts;
    private final ImmutableList<ValuePathPart> returnPathParts;

    public static MessageTemplateImpl create(String template, MethodInfo methodInfo) {
        ArrayList<Part> allParts = Lists.newArrayList();
        ArrayList<ValuePathPart> thisPathParts = Lists.newArrayList();
        ArrayList<ArgPathPart> argPathParts = Lists.newArrayList();
        ArrayList<ValuePathPart> returnPathParts = Lists.newArrayList();
        Matcher matcher = pattern.matcher(template);
        int curr = 0;
        while (matcher.find()) {
            String remaining;
            String base;
            String group;
            String path;
            int index;
            if (matcher.start() > curr) {
                allParts.add(new ConstantPart(template.substring(curr, matcher.start())));
            }
            if ((index = (path = (group = Preconditions.checkNotNull(matcher.group(1))).trim()).indexOf(46)) == -1) {
                base = path;
                remaining = "";
            } else {
                base = path.substring(0, index);
                remaining = path.substring(index + 1);
            }
            if (base.equals("this")) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(methodInfo.getDeclaringClassName(), false, methodInfo.getLoader());
                }
                catch (ClassNotFoundException e) {
                    logger.debug(e.getMessage(), e);
                    clazz = null;
                }
                ValuePathPart part = new ValuePathPart(PartType.THIS_PATH, clazz, remaining);
                allParts.add(part);
                thisPathParts.add(part);
            } else if (base.matches("[0-9]+")) {
                List<Class<?>> parameterTypes;
                int argNumber = Integer.parseInt(base);
                if (argNumber < (parameterTypes = methodInfo.getParameterTypes()).size()) {
                    ArgPathPart part = new ArgPathPart(parameterTypes.get(argNumber), remaining, argNumber);
                    allParts.add(part);
                    argPathParts.add(part);
                } else {
                    allParts.add(new ConstantPart("<requested arg index out of bounds: " + argNumber + ">"));
                }
            } else if (base.equals("_")) {
                ValuePathPart part = new ValuePathPart(PartType.RETURN_PATH, methodInfo.getReturnType(), remaining);
                allParts.add(part);
                returnPathParts.add(part);
            } else if (base.equals("methodName")) {
                allParts.add(new Part(PartType.METHOD_NAME));
            } else {
                logger.warn("invalid template substitution: {}", (Object)path);
                allParts.add(new ConstantPart("{{" + path + "}}"));
            }
            curr = matcher.end();
        }
        if (curr < template.length()) {
            allParts.add(new ConstantPart(template.substring(curr)));
        }
        return new MessageTemplateImpl(allParts, thisPathParts, argPathParts, returnPathParts);
    }

    private MessageTemplateImpl(List<Part> allParts, List<ValuePathPart> thisPathParts, List<ArgPathPart> argPathParts, List<ValuePathPart> returnPathParts) {
        this.allParts = ImmutableList.copyOf(allParts);
        this.thisPathParts = ImmutableList.copyOf(thisPathParts);
        this.argPathParts = ImmutableList.copyOf(argPathParts);
        this.returnPathParts = ImmutableList.copyOf(returnPathParts);
    }

    ImmutableList<Part> getAllParts() {
        return this.allParts;
    }

    ImmutableList<ValuePathPart> getThisPathParts() {
        return this.thisPathParts;
    }

    ImmutableList<ArgPathPart> getArgPathParts() {
        return this.argPathParts;
    }

    ImmutableList<ValuePathPart> getReturnPathParts() {
        return this.returnPathParts;
    }

    static class PathEvaluator {
        private static final Splitter splitter = Splitter.on('.').omitEmptyStrings();
        private final Accessor[] accessors;
        private final List<String> remainingPath;
        @Nullable
        private final String format;
        @Nullable
        private final String formatArg;

        static PathEvaluator create(@Nullable Class<?> type, String pathAndFormat) {
            String formatArg;
            String format;
            String path;
            int index = pathAndFormat.indexOf(124);
            if (index == -1) {
                path = pathAndFormat;
                format = null;
                formatArg = null;
            } else {
                path = pathAndFormat.substring(0, index).trim();
                String formatAndArg = pathAndFormat.substring(index + 1).trim();
                if ((index = formatAndArg.indexOf(58)) == -1) {
                    format = formatAndArg;
                    formatArg = null;
                } else {
                    format = formatAndArg.substring(0, index);
                    formatArg = formatAndArg.substring(index + 1);
                }
            }
            ArrayList<Accessor> accessors = Lists.newArrayList();
            if (type == null) {
                return new PathEvaluator(accessors, splitter.splitToList(path), format, formatArg);
            }
            ArrayList<String> parts = Lists.newArrayList(splitter.split(path));
            Class<?> currType = type;
            while (!parts.isEmpty()) {
                String currPart = (String)parts.remove(0);
                Accessor accessor = Beans.loadPossiblyArrayBasedAccessor(currType, currPart);
                if (accessor == null) {
                    parts.add(0, currPart);
                    break;
                }
                accessors.add(accessor);
                currType = accessor.getValueType();
            }
            return new PathEvaluator(accessors, parts, format, formatArg);
        }

        private PathEvaluator(List<Accessor> accessors, List<String> remainingPath, @Nullable String format, @Nullable String formatArg) {
            this.accessors = accessors.toArray(new Accessor[accessors.size()]);
            this.remainingPath = remainingPath;
            this.format = format;
            this.formatArg = formatArg;
        }

        @Nullable
        Object evaluateOnBase(Object base) throws Exception {
            Object curr = base;
            for (Accessor accessor : this.accessors) {
                if ((curr = accessor.evaluate(curr)) != null) continue;
                return null;
            }
            if (!this.remainingPath.isEmpty()) {
                curr = Beans.value(curr, this.remainingPath);
            }
            if ("charset".equals(this.format) && this.formatArg != null && curr instanceof byte[]) {
                if (this.formatArg.equals("default")) {
                    return new String((byte[])curr);
                }
                return new String((byte[])curr, this.formatArg);
            }
            return curr;
        }
    }

    static class ArgPathPart
    extends ValuePathPart {
        private final int argNumber;

        private ArgPathPart(Class<?> argClass, String propertyPath, int argNumber) {
            super(PartType.ARG_PATH, argClass, propertyPath);
            this.argNumber = argNumber;
        }

        int getArgNumber() {
            return this.argNumber;
        }
    }

    static class ValuePathPart
    extends Part {
        private static final char[] hexDigits = "0123456789abcdef".toCharArray();
        private final PathEvaluator pathEvaluator;

        ValuePathPart(PartType partType, @Nullable Class<?> type, String pathAndFormat) {
            super(partType);
            this.pathEvaluator = PathEvaluator.create(type, pathAndFormat);
        }

        String evaluatePart(@Nullable Object base) {
            if (base == null) {
                return "null";
            }
            try {
                return ValuePathPart.valueOf(this.pathEvaluator.evaluateOnBase(base));
            }
            catch (InvocationTargetException e) {
                logger.debug(e.getMessage(), e);
                return "<error evaluating: " + Throwables.getBestMessage(e) + ">";
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
                return "<error evaluating: " + Throwables.getBestMessage(e) + ">";
            }
        }

        private static String valueOf(@Nullable Object value) {
            if (value == null) {
                return String.valueOf(value);
            }
            if (value instanceof byte[]) {
                return ValuePathPart.toHex((byte[])value);
            }
            if (value instanceof List || value.getClass().isArray()) {
                StringBuilder sb = new StringBuilder();
                ValuePathPart.appendValue(sb, value);
                return sb.toString();
            }
            return String.valueOf(value);
        }

        private static void appendValue(StringBuilder sb, @Nullable Object value) {
            if (value == null) {
                sb.append(String.valueOf(value));
            } else if (value instanceof Iterable) {
                ValuePathPart.appendIterable(sb, (Iterable)value);
            } else if (value.getClass().isArray()) {
                ValuePathPart.appendArray(sb, value);
            } else {
                sb.append(String.valueOf(value));
            }
        }

        private static void appendIterable(StringBuilder sb, Iterable<?> items) {
            sb.append('[');
            boolean comma = false;
            for (Object item : items) {
                if (comma) {
                    sb.append(", ");
                }
                ValuePathPart.appendValue(sb, item);
                comma = true;
            }
            sb.append(']');
        }

        private static void appendArray(StringBuilder sb, Object array) {
            sb.append('[');
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                ValuePathPart.appendValue(sb, Array.get(array, i));
            }
            sb.append(']');
        }

        private static String toHex(byte[] bytes) {
            StringBuilder sb = new StringBuilder(2 + 2 * bytes.length);
            sb.append("0x");
            for (byte b : bytes) {
                sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
            }
            return sb.toString();
        }
    }

    static class ConstantPart
    extends Part {
        private final String constant;

        private ConstantPart(String constant) {
            super(PartType.CONSTANT);
            this.constant = constant;
        }

        String getConstant() {
            return this.constant;
        }
    }

    static class Part {
        private final PartType type;

        private Part(PartType type) {
            this.type = type;
        }

        PartType getType() {
            return this.type;
        }
    }

    static enum PartType {
        CONSTANT,
        THIS_PATH,
        ARG_PATH,
        RETURN_PATH,
        METHOD_NAME;

    }
}

