/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.weaving.PluginDetail;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginDetail.PointcutMethod", generator="Immutables")
@Immutable
public final class ImmutablePointcutMethod
extends PluginDetail.PointcutMethod {
    private final String name;
    private final String descriptor;
    private final ImmutableSet<Type> annotationTypes;
    private final ImmutableMap<Integer, List<Type>> parameterAnnotationTypes;
    private final transient Method toAsmMethod;

    private ImmutablePointcutMethod(String name, String descriptor, ImmutableSet<Type> annotationTypes, ImmutableMap<Integer, List<Type>> parameterAnnotationTypes) {
        this.name = name;
        this.descriptor = descriptor;
        this.annotationTypes = annotationTypes;
        this.parameterAnnotationTypes = parameterAnnotationTypes;
        this.toAsmMethod = Preconditions.checkNotNull(super.toAsmMethod(), "toAsmMethod");
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="descriptor")
    String descriptor() {
        return this.descriptor;
    }

    @JsonProperty(value="annotationTypes")
    ImmutableSet<Type> annotationTypes() {
        return this.annotationTypes;
    }

    @JsonProperty(value="parameterAnnotationTypes")
    ImmutableMap<Integer, List<Type>> parameterAnnotationTypes() {
        return this.parameterAnnotationTypes;
    }

    @Override
    @JsonProperty(value="toAsmMethod")
    Method toAsmMethod() {
        return this.toAsmMethod;
    }

    public final ImmutablePointcutMethod withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePointcutMethod(newValue, this.descriptor, this.annotationTypes, this.parameterAnnotationTypes);
    }

    public final ImmutablePointcutMethod withDescriptor(String value) {
        String newValue = Preconditions.checkNotNull(value, "descriptor");
        if (this.descriptor.equals(newValue)) {
            return this;
        }
        return new ImmutablePointcutMethod(this.name, newValue, this.annotationTypes, this.parameterAnnotationTypes);
    }

    public final ImmutablePointcutMethod withAnnotationTypes(Type ... elements) {
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new ImmutablePointcutMethod(this.name, this.descriptor, newValue, this.parameterAnnotationTypes);
    }

    public final ImmutablePointcutMethod withAnnotationTypes(Iterable<? extends Type> elements) {
        if (this.annotationTypes == elements) {
            return this;
        }
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new ImmutablePointcutMethod(this.name, this.descriptor, newValue, this.parameterAnnotationTypes);
    }

    public final ImmutablePointcutMethod withParameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
        if (this.parameterAnnotationTypes == entries) {
            return this;
        }
        ImmutableMap<Integer, List<Type>> newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePointcutMethod(this.name, this.descriptor, this.annotationTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePointcutMethod && this.equalTo((ImmutablePointcutMethod)another);
    }

    private boolean equalTo(ImmutablePointcutMethod another) {
        return this.name.equals(another.name) && this.descriptor.equals(another.descriptor) && this.annotationTypes.equals(another.annotationTypes) && this.parameterAnnotationTypes.equals(another.parameterAnnotationTypes) && this.toAsmMethod.equals(another.toAsmMethod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.descriptor.hashCode();
        h += (h << 5) + this.annotationTypes.hashCode();
        h += (h << 5) + this.parameterAnnotationTypes.hashCode();
        h += (h << 5) + this.toAsmMethod.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PointcutMethod").omitNullValues().add("name", this.name).add("descriptor", this.descriptor).add("annotationTypes", this.annotationTypes).add("parameterAnnotationTypes", this.parameterAnnotationTypes).add("toAsmMethod", this.toAsmMethod).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePointcutMethod fromJson(Json json) {
        Builder builder = ImmutablePointcutMethod.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.descriptor != null) {
            builder.descriptor(json.descriptor);
        }
        if (json.annotationTypes != null) {
            builder.addAllAnnotationTypes(json.annotationTypes);
        }
        if (json.parameterAnnotationTypes != null) {
            builder.putAllParameterAnnotationTypes(json.parameterAnnotationTypes);
        }
        return builder.build();
    }

    public static ImmutablePointcutMethod copyOf(PluginDetail.PointcutMethod instance) {
        if (instance instanceof ImmutablePointcutMethod) {
            return (ImmutablePointcutMethod)instance;
        }
        return ImmutablePointcutMethod.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginDetail.PointcutMethod", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTOR = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String descriptor;
        private ImmutableSet.Builder<Type> annotationTypes = ImmutableSet.builder();
        private ImmutableMap.Builder<Integer, List<Type>> parameterAnnotationTypes = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginDetail.PointcutMethod instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            this.descriptor(instance.descriptor());
            this.addAllAnnotationTypes(instance.annotationTypes());
            this.putAllParameterAnnotationTypes(instance.parameterAnnotationTypes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder descriptor(String descriptor) {
            this.descriptor = Preconditions.checkNotNull(descriptor, "descriptor");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotationTypes(Type element) {
            this.annotationTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotationTypes(Type ... elements) {
            this.annotationTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder annotationTypes(Iterable<? extends Type> elements) {
            this.annotationTypes = ImmutableSet.builder();
            return this.addAllAnnotationTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAnnotationTypes(Iterable<? extends Type> elements) {
            this.annotationTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameterAnnotationTypes(int key, List<Type> value) {
            this.parameterAnnotationTypes.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameterAnnotationTypes(Map.Entry<Integer, ? extends List<Type>> entry) {
            this.parameterAnnotationTypes.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
            this.parameterAnnotationTypes = ImmutableMap.builder();
            return this.putAllParameterAnnotationTypes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllParameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
            this.parameterAnnotationTypes.putAll(entries);
            return this;
        }

        public ImmutablePointcutMethod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePointcutMethod(this.name, this.descriptor, (ImmutableSet)this.annotationTypes.build(), this.parameterAnnotationTypes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("descriptor");
            }
            return "Cannot build PointcutMethod, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginDetail.PointcutMethod", generator="Immutables")
    static final class Json
    extends PluginDetail.PointcutMethod {
        @Nullable
        String name;
        @Nullable
        String descriptor;
        @Nullable
        Set<Type> annotationTypes = ImmutableSet.of();
        @Nullable
        Map<Integer, List<Type>> parameterAnnotationTypes = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="descriptor")
        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        @JsonProperty(value="annotationTypes")
        public void setAnnotationTypes(Set<Type> annotationTypes) {
            this.annotationTypes = annotationTypes;
        }

        @JsonProperty(value="parameterAnnotationTypes")
        public void setParameterAnnotationTypes(Map<Integer, List<Type>> parameterAnnotationTypes) {
            this.parameterAnnotationTypes = parameterAnnotationTypes;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        String descriptor() {
            throw new UnsupportedOperationException();
        }

        @Override
        Set<Type> annotationTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        Map<Integer, List<Type>> parameterAnnotationTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        Method toAsmMethod() {
            throw new UnsupportedOperationException();
        }
    }
}

