/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.ClassAnalyzer;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassAnalyzer.AnalyzedMethodKey", generator="Immutables")
@Immutable
final class ImmutableAnalyzedMethodKey
extends ClassAnalyzer.AnalyzedMethodKey {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    @Nullable
    private final AnalyzedMethod analyzedMethod;

    private ImmutableAnalyzedMethodKey(String name, ImmutableList<String> parameterTypes, @Nullable AnalyzedMethod analyzedMethod) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.analyzedMethod = analyzedMethod;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="analyzedMethod")
    @Nullable
    AnalyzedMethod analyzedMethod() {
        return this.analyzedMethod;
    }

    public final ImmutableAnalyzedMethodKey withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedMethodKey(newValue, this.parameterTypes, this.analyzedMethod);
    }

    public final ImmutableAnalyzedMethodKey withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
    }

    public final ImmutableAnalyzedMethodKey withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
    }

    public final ImmutableAnalyzedMethodKey withAnalyzedMethod(@Nullable AnalyzedMethod value) {
        if (this.analyzedMethod == value) {
            return this;
        }
        return new ImmutableAnalyzedMethodKey(this.name, this.parameterTypes, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalyzedMethodKey && this.equalTo((ImmutableAnalyzedMethodKey)another);
    }

    private boolean equalTo(ImmutableAnalyzedMethodKey another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.parameterTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedMethodKey").omitNullValues().add("name", this.name).add("parameterTypes", this.parameterTypes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalyzedMethodKey fromJson(Json json) {
        Builder builder = ImmutableAnalyzedMethodKey.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.parameterTypes != null) {
            builder.addAllParameterTypes(json.parameterTypes);
        }
        if (json.analyzedMethod != null) {
            builder.analyzedMethod(json.analyzedMethod);
        }
        return builder.build();
    }

    public static ImmutableAnalyzedMethodKey copyOf(ClassAnalyzer.AnalyzedMethodKey instance) {
        if (instance instanceof ImmutableAnalyzedMethodKey) {
            return (ImmutableAnalyzedMethodKey)instance;
        }
        return ImmutableAnalyzedMethodKey.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassAnalyzer.AnalyzedMethodKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypes = ImmutableList.builder();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private AnalyzedMethod analyzedMethod;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClassAnalyzer.AnalyzedMethodKey instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            this.addAllParameterTypes(instance.parameterTypes());
            AnalyzedMethod analyzedMethodValue = instance.analyzedMethod();
            if (analyzedMethodValue != null) {
                this.analyzedMethod(analyzedMethodValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String element) {
            this.parameterTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypes = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypes.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analyzedMethod(@Nullable AnalyzedMethod analyzedMethod) {
            this.analyzedMethod = analyzedMethod;
            return this;
        }

        public ImmutableAnalyzedMethodKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalyzedMethodKey(this.name, (ImmutableList)this.parameterTypes.build(), this.analyzedMethod);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build AnalyzedMethodKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClassAnalyzer.AnalyzedMethodKey", generator="Immutables")
    static final class Json
    extends ClassAnalyzer.AnalyzedMethodKey {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String name;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<String> parameterTypes = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        AnalyzedMethod analyzedMethod;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="parameterTypes")
        public void setParameterTypes(ImmutableList<String> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @JsonProperty(value="analyzedMethod")
        public void setAnalyzedMethod(@Nullable AnalyzedMethod analyzedMethod) {
            this.analyzedMethod = analyzedMethod;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> parameterTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        AnalyzedMethod analyzedMethod() {
            throw new UnsupportedOperationException();
        }
    }
}

