/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.weaving.AnalyzedClass;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalyzedWorld.AnalyzedClassAndLoader", generator="Immutables")
@Immutable
final class ImmutableAnalyzedClassAndLoader
implements AnalyzedWorld.AnalyzedClassAndLoader {
    private final AnalyzedClass analyzedClass;
    @Nullable
    private final ClassLoader analyzedClassLoader;

    private ImmutableAnalyzedClassAndLoader(AnalyzedClass analyzedClass, @Nullable ClassLoader analyzedClassLoader) {
        this.analyzedClass = Preconditions.checkNotNull(analyzedClass, "analyzedClass");
        this.analyzedClassLoader = analyzedClassLoader;
    }

    private ImmutableAnalyzedClassAndLoader(ImmutableAnalyzedClassAndLoader original, AnalyzedClass analyzedClass, @Nullable ClassLoader analyzedClassLoader) {
        this.analyzedClass = analyzedClass;
        this.analyzedClassLoader = analyzedClassLoader;
    }

    @Override
    @JsonProperty(value="analyzedClass")
    public AnalyzedClass analyzedClass() {
        return this.analyzedClass;
    }

    @Override
    @JsonProperty(value="analyzedClassLoader")
    @Nullable
    public ClassLoader analyzedClassLoader() {
        return this.analyzedClassLoader;
    }

    public final ImmutableAnalyzedClassAndLoader withAnalyzedClass(AnalyzedClass value) {
        if (this.analyzedClass == value) {
            return this;
        }
        AnalyzedClass newValue = Preconditions.checkNotNull(value, "analyzedClass");
        return new ImmutableAnalyzedClassAndLoader(this, newValue, this.analyzedClassLoader);
    }

    public final ImmutableAnalyzedClassAndLoader withAnalyzedClassLoader(@Nullable ClassLoader value) {
        if (this.analyzedClassLoader == value) {
            return this;
        }
        return new ImmutableAnalyzedClassAndLoader(this, this.analyzedClass, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalyzedClassAndLoader && this.equalTo((ImmutableAnalyzedClassAndLoader)another);
    }

    private boolean equalTo(ImmutableAnalyzedClassAndLoader another) {
        return this.analyzedClass.equals(another.analyzedClass) && Objects.equal(this.analyzedClassLoader, another.analyzedClassLoader);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.analyzedClass.hashCode();
        h += (h << 5) + Objects.hashCode(this.analyzedClassLoader);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedClassAndLoader").omitNullValues().add("analyzedClass", this.analyzedClass).add("analyzedClassLoader", this.analyzedClassLoader).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalyzedClassAndLoader fromJson(Json json) {
        Builder builder = ImmutableAnalyzedClassAndLoader.builder();
        if (json.analyzedClass != null) {
            builder.analyzedClass(json.analyzedClass);
        }
        if (json.analyzedClassLoader != null) {
            builder.analyzedClassLoader(json.analyzedClassLoader);
        }
        return builder.build();
    }

    public static ImmutableAnalyzedClassAndLoader of(AnalyzedClass analyzedClass, @Nullable ClassLoader analyzedClassLoader) {
        return new ImmutableAnalyzedClassAndLoader(analyzedClass, analyzedClassLoader);
    }

    public static ImmutableAnalyzedClassAndLoader copyOf(AnalyzedWorld.AnalyzedClassAndLoader instance) {
        if (instance instanceof ImmutableAnalyzedClassAndLoader) {
            return (ImmutableAnalyzedClassAndLoader)instance;
        }
        return ImmutableAnalyzedClassAndLoader.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedWorld.AnalyzedClassAndLoader", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ANALYZED_CLASS = 1L;
        private long initBits = 1L;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private AnalyzedClass analyzedClass;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private ClassLoader analyzedClassLoader;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AnalyzedWorld.AnalyzedClassAndLoader instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.analyzedClass(instance.analyzedClass());
            ClassLoader analyzedClassLoaderValue = instance.analyzedClassLoader();
            if (analyzedClassLoaderValue != null) {
                this.analyzedClassLoader(analyzedClassLoaderValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analyzedClass(AnalyzedClass analyzedClass) {
            this.analyzedClass = Preconditions.checkNotNull(analyzedClass, "analyzedClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analyzedClassLoader(@Nullable ClassLoader analyzedClassLoader) {
            this.analyzedClassLoader = analyzedClassLoader;
            return this;
        }

        public ImmutableAnalyzedClassAndLoader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalyzedClassAndLoader(null, this.analyzedClass, this.analyzedClassLoader);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("analyzedClass");
            }
            return "Cannot build AnalyzedClassAndLoader, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalyzedWorld.AnalyzedClassAndLoader", generator="Immutables")
    static final class Json
    implements AnalyzedWorld.AnalyzedClassAndLoader {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        AnalyzedClass analyzedClass;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ClassLoader analyzedClassLoader;

        Json() {
        }

        @JsonProperty(value="analyzedClass")
        public void setAnalyzedClass(AnalyzedClass analyzedClass) {
            this.analyzedClass = analyzedClass;
        }

        @JsonProperty(value="analyzedClassLoader")
        public void setAnalyzedClassLoader(@Nullable ClassLoader analyzedClassLoader) {
            this.analyzedClassLoader = analyzedClassLoader;
        }

        @Override
        public AnalyzedClass analyzedClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassLoader analyzedClassLoader() {
            throw new UnsupportedOperationException();
        }
    }
}

