/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AdviceGenerator;
import org.glowroot.agent.weaving.AdviceMatcher;
import org.glowroot.agent.weaving.AnalyzedClass;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.ImmutableAnalyzedClass;
import org.glowroot.agent.weaving.ImmutableAnalyzedMethod;
import org.glowroot.agent.weaving.ImmutableAnalyzedMethodKey;
import org.glowroot.agent.weaving.ImmutableMatchedMixinTypes;
import org.glowroot.agent.weaving.ImmutableParseContext;
import org.glowroot.agent.weaving.ImmutablePublicFinalMethod;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PublicFinalMethod;
import org.glowroot.agent.weaving.ShimType;
import org.glowroot.agent.weaving.ThinClassVisitor;
import org.immutables.value.Value;

class ClassAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(ClassAnalyzer.class);
    private final ThinClassVisitor.ThinClass thinClass;
    private final String className;
    private final boolean intf;
    @Nullable
    private final ClassLoader loader;
    private final ImmutableAnalyzedClass.Builder analyzedClassBuilder;
    private final ImmutableList<AdviceMatcher> adviceMatchers;
    private final ImmutableList<AnalyzedClass> superAnalyzedClasses;
    private final ImmutableList<ShimType> matchedShimTypes;
    private final MatchedMixinTypes matchedMixinTypes;
    private final boolean hasMainMethod;
    private final boolean isClassLoader;
    private final ImmutableSet<String> superClassNames;
    private final boolean shortCircuitBeforeAnalyzeMethods;
    private final byte[] classBytes;
    private final boolean hackAdvisors;
    @MonotonicNonNull
    private Map<String, List<Advice>> methodAdvisors;
    @MonotonicNonNull
    private List<AnalyzedMethod> methodsThatOnlyNowFulfillAdvice;
    @MonotonicNonNull
    private Map<ThinClassVisitor.ThinMethod, List<Advice>> bridgeTargetAdvisors;

    ClassAnalyzer(ThinClassVisitor.ThinClass thinClass, List<Advice> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, @Nullable ClassLoader loader, AnalyzedWorld analyzedWorld, @Nullable CodeSource codeSource, byte[] classBytes, @Nullable Class<?> classBeingRedefined, boolean noLongerNeedToWeaveMainMethods) {
        this.thinClass = thinClass;
        this.loader = loader;
        ImmutableList<String> interfaceNames = ClassNames.fromInternalNames(thinClass.interfaces());
        this.className = ClassNames.fromInternalName(thinClass.name());
        this.intf = Modifier.isInterface(thinClass.access());
        String superClassName = ClassNames.fromInternalName(thinClass.superName());
        this.analyzedClassBuilder = ImmutableAnalyzedClass.builder().modifiers(thinClass.access()).name(this.className).superName(superClassName).addAllInterfaceNames(interfaceNames);
        boolean ejbRemote = false;
        boolean ejbStateless = false;
        for (String annotation : thinClass.annotations()) {
            if (annotation.equals("Ljavax/ejb/Remote;")) {
                ejbRemote = true;
                continue;
            }
            if (!annotation.equals("Ljavax/ejb/Stateless;")) continue;
            ejbStateless = true;
        }
        ImmutableParseContext parseContext = ImmutableParseContext.of(this.className, codeSource);
        ArrayList<AnalyzedClass> interfaceAnalyzedHierarchy = Lists.newArrayList();
        ArrayList<AnalyzedClass> superAnalyzedClasses = Lists.newArrayList();
        for (String interfaceName : interfaceNames) {
            interfaceAnalyzedHierarchy.addAll(analyzedWorld.getAnalyzedHierarchy(interfaceName, loader, this.className, parseContext));
        }
        superAnalyzedClasses.addAll(interfaceAnalyzedHierarchy);
        if (this.intf) {
            this.matchedShimTypes = ClassAnalyzer.getMatchedShimTypes(shimTypes, this.className, ImmutableList.<AnalyzedClass>of(), ImmutableList.<AnalyzedClass>of());
            this.matchedMixinTypes = ClassAnalyzer.getMatchedMixinTypes(mixinTypes, this.className, classBeingRedefined, ImmutableList.<AnalyzedClass>of(), ImmutableList.<AnalyzedClass>of());
            this.hasMainMethod = false;
            this.isClassLoader = false;
        } else {
            List<AnalyzedClass> superAnalyzedHierarchy = analyzedWorld.getAnalyzedHierarchy(superClassName, loader, this.className, parseContext);
            superAnalyzedClasses.addAll(superAnalyzedHierarchy);
            this.matchedShimTypes = ClassAnalyzer.getMatchedShimTypes(shimTypes, this.className, superAnalyzedHierarchy, interfaceAnalyzedHierarchy);
            this.matchedMixinTypes = ClassAnalyzer.getMatchedMixinTypes(mixinTypes, this.className, classBeingRedefined, superAnalyzedHierarchy, interfaceAnalyzedHierarchy);
            if (noLongerNeedToWeaveMainMethods) {
                this.hasMainMethod = false;
            } else {
                boolean bl = this.hasMainMethod = ClassAnalyzer.hasMainOrPossibleProcrunStartMethod(thinClass.nonBridgeMethods()) || this.className.equals("org.apache.commons.daemon.support.DaemonLoader");
            }
            if (this.className.startsWith("org.glowroot.agent.tests.")) {
                this.isClassLoader = false;
            } else {
                boolean isClassLoader = false;
                for (AnalyzedClass superAnalyzedClass : superAnalyzedHierarchy) {
                    if (!superAnalyzedClass.name().equals(ClassLoader.class.getName())) continue;
                    isClassLoader = true;
                    break;
                }
                this.isClassLoader = isClassLoader;
            }
        }
        this.analyzedClassBuilder.addAllShimTypes(this.matchedShimTypes);
        this.analyzedClassBuilder.addAllMixinTypes(this.matchedMixinTypes.reweavable());
        this.analyzedClassBuilder.addAllNonReweavableMixinTypes(this.matchedMixinTypes.nonReweavable());
        if ((ejbRemote || ejbStateless) && !this.intf) {
            Set<String> ejbRemoteInterfaces = ClassAnalyzer.getEjbRemoteInterfaces(thinClass, superAnalyzedClasses);
            if (ejbRemoteInterfaces.isEmpty()) {
                this.superAnalyzedClasses = ImmutableList.copyOf(superAnalyzedClasses);
                this.analyzedClassBuilder.ejbRemote(ejbRemote);
            } else if (loader == null) {
                logger.warn("instrumenting @javax.ejb.Remote not currently supported in bootstrap class loader: {}", (Object)this.className);
                this.superAnalyzedClasses = ImmutableList.copyOf(superAnalyzedClasses);
                this.analyzedClassBuilder.ejbRemote(false);
            } else {
                List<AnalyzedClass> ejbHackedSuperAnalyzedClasses = ClassAnalyzer.hack(thinClass, loader, superAnalyzedClasses, ejbRemoteInterfaces);
                this.superAnalyzedClasses = ImmutableList.copyOf(ejbHackedSuperAnalyzedClasses);
                this.analyzedClassBuilder.ejbRemote(true);
            }
        } else {
            this.superAnalyzedClasses = ImmutableList.copyOf(superAnalyzedClasses);
            this.analyzedClassBuilder.ejbRemote(ejbRemote);
        }
        HashSet<String> superClassNames = Sets.newHashSet();
        superClassNames.add(this.className);
        for (AnalyzedClass analyzedClass : superAnalyzedClasses) {
            superClassNames.add(analyzedClass.name());
        }
        this.superClassNames = ImmutableSet.copyOf(superClassNames);
        this.adviceMatchers = AdviceMatcher.getAdviceMatchers(this.className, thinClass.annotations(), superClassNames, advisors);
        this.shortCircuitBeforeAnalyzeMethods = this.intf ? false : !ClassAnalyzer.hasSuperAdvice(this.superAnalyzedClasses) && this.matchedShimTypes.isEmpty() && this.matchedMixinTypes.reweavable().isEmpty() && this.adviceMatchers.isEmpty();
        this.classBytes = classBytes;
        this.hackAdvisors = loader != null;
    }

    void analyzeMethods() throws ClassNotFoundException, IOException {
        List<Advice> advisors;
        this.methodAdvisors = Maps.newHashMap();
        this.bridgeTargetAdvisors = Maps.newHashMap();
        for (ThinClassVisitor.ThinMethod bridgeMethod : this.thinClass.bridgeMethods()) {
            ThinClassVisitor.ThinMethod targetMethod;
            advisors = this.analyzeMethod(bridgeMethod);
            if (advisors.isEmpty() || (targetMethod = this.getTargetMethod(bridgeMethod)) == null) continue;
            this.bridgeTargetAdvisors.put(targetMethod, advisors);
        }
        for (ThinClassVisitor.ThinMethod nonBridgeMethod : this.thinClass.nonBridgeMethods()) {
            advisors = this.analyzeMethod(nonBridgeMethod);
            if (this.hackAdvisors) {
                ListIterator<Advice> i = advisors.listIterator();
                while (i.hasNext()) {
                    Advice advice = i.next();
                    Advice nonBootstrapLoaderAdvice = advice.nonBootstrapLoaderAdvice();
                    if (nonBootstrapLoaderAdvice == null) continue;
                    i.set(nonBootstrapLoaderAdvice);
                }
            }
            if (advisors.isEmpty()) continue;
            this.methodAdvisors.put(nonBridgeMethod.name() + nonBridgeMethod.descriptor(), advisors);
        }
        ImmutableAnalyzedClass mostlyAnalyzedClass = this.analyzedClassBuilder.build();
        this.methodsThatOnlyNowFulfillAdvice = this.getMethodsThatOnlyNowFulfillAdvice(mostlyAnalyzedClass);
        this.analyzedClassBuilder.addAllAnalyzedMethods(this.methodsThatOnlyNowFulfillAdvice);
    }

    boolean isWeavingRequired() {
        Preconditions.checkNotNull(this.methodAdvisors);
        Preconditions.checkNotNull(this.methodsThatOnlyNowFulfillAdvice);
        if (Modifier.isInterface(this.thinClass.access())) {
            return !this.methodAdvisors.isEmpty() || !this.matchedMixinTypes.reweavable().isEmpty();
        }
        return !this.methodAdvisors.isEmpty() || !this.methodsThatOnlyNowFulfillAdvice.isEmpty() || !this.matchedShimTypes.isEmpty() || !this.matchedMixinTypes.reweavable().isEmpty() || this.hasMainMethod || this.isClassLoader;
    }

    ImmutableList<ShimType> getMatchedShimTypes() {
        return this.matchedShimTypes;
    }

    List<MixinType> getMatchedReweavableMixinTypes() {
        return this.matchedMixinTypes.reweavable();
    }

    Map<String, List<Advice>> getMethodAdvisors() {
        return Preconditions.checkNotNull(this.methodAdvisors);
    }

    AnalyzedClass getAnalyzedClass() {
        return this.analyzedClassBuilder.build();
    }

    boolean isClassLoader() {
        return this.isClassLoader;
    }

    List<AnalyzedMethod> getMethodsThatOnlyNowFulfillAdvice() {
        return Preconditions.checkNotNull(this.methodsThatOnlyNowFulfillAdvice);
    }

    @RequiresNonNull(value={"bridgeTargetAdvisors"})
    private List<Advice> analyzeMethod(ThinClassVisitor.ThinMethod thinMethod) {
        boolean intfMethod;
        if (Modifier.isFinal(thinMethod.access()) && Modifier.isPublic(thinMethod.access())) {
            ImmutablePublicFinalMethod.Builder builder = ImmutablePublicFinalMethod.builder().name(thinMethod.name());
            List<Type> parameterTypes = Arrays.asList(Type.getArgumentTypes(thinMethod.descriptor()));
            for (Type parameterType : parameterTypes) {
                builder.addParameterTypes(parameterType.getClassName());
            }
            this.analyzedClassBuilder.addPublicFinalMethods((PublicFinalMethod)builder.build());
        }
        if (this.shortCircuitBeforeAnalyzeMethods) {
            return ImmutableList.of();
        }
        List<Type> parameterTypes = Arrays.asList(Type.getArgumentTypes(thinMethod.descriptor()));
        Type returnType = Type.getReturnType(thinMethod.descriptor());
        List<String> methodAnnotations = thinMethod.annotations();
        List<Advice> matchingAdvisors = this.getMatchingAdvisors(thinMethod, methodAnnotations, parameterTypes, returnType);
        boolean bl = intfMethod = this.intf && !Modifier.isStatic(thinMethod.access());
        if (matchingAdvisors.isEmpty() && !intfMethod) {
            return ImmutableList.of();
        }
        ImmutableAnalyzedMethod.Builder builder = ImmutableAnalyzedMethod.builder();
        builder.name(thinMethod.name());
        for (Type parameterType : parameterTypes) {
            builder.addParameterTypes(parameterType.getClassName());
        }
        builder.returnType(returnType.getClassName()).modifiers(thinMethod.access()).signature(thinMethod.signature());
        for (String exception : thinMethod.exceptions()) {
            builder.addExceptions(ClassNames.fromInternalName(exception));
        }
        ArrayList<Advice> subTypeRestrictedAdvisors = Lists.newArrayList();
        Iterator<Advice> i = matchingAdvisors.iterator();
        while (i.hasNext()) {
            Advice advice = i.next();
            if (ClassAnalyzer.isSubTypeRestrictionMatch(advice, this.superClassNames)) continue;
            subTypeRestrictedAdvisors.add(advice);
            i.remove();
        }
        builder.addAllAdvisors(matchingAdvisors).addAllSubTypeRestrictedAdvisors(subTypeRestrictedAdvisors);
        this.analyzedClassBuilder.addAnalyzedMethods((AnalyzedMethod)builder.build());
        return matchingAdvisors;
    }

    @RequiresNonNull(value={"bridgeTargetAdvisors"})
    private List<Advice> getMatchingAdvisors(ThinClassVisitor.ThinMethod thinMethod, List<String> methodAnnotations, List<Type> parameterTypes, Type returnType) {
        List<Advice> extraAdvisors;
        HashSet<Advice> matchingAdvisors = Sets.newHashSet();
        for (AdviceMatcher adviceMatcher : this.adviceMatchers) {
            if (!adviceMatcher.isMethodLevelMatch(thinMethod.name(), methodAnnotations, parameterTypes, returnType, thinMethod.access())) continue;
            matchingAdvisors.add(adviceMatcher.advice());
        }
        if (!thinMethod.name().equals("<init>")) {
            for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
                for (AnalyzedMethod analyzedMethod : superAnalyzedClass.analyzedMethods()) {
                    if (!analyzedMethod.isOverriddenBy(thinMethod.name(), parameterTypes)) continue;
                    matchingAdvisors.addAll(analyzedMethod.advisors());
                    for (Advice subTypeRestrictedAdvice : analyzedMethod.subTypeRestrictedAdvisors()) {
                        if (!ClassAnalyzer.isSubTypeRestrictionMatch(subTypeRestrictedAdvice, this.superClassNames)) continue;
                        matchingAdvisors.add(subTypeRestrictedAdvice);
                    }
                }
            }
        }
        if ((extraAdvisors = this.bridgeTargetAdvisors.get(thinMethod)) != null) {
            matchingAdvisors.addAll(extraAdvisors);
        }
        return ClassAnalyzer.sortAdvisors(matchingAdvisors);
    }

    @Nullable
    private ThinClassVisitor.ThinMethod getTargetMethod(ThinClassVisitor.ThinMethod bridgeMethod) {
        List<ThinClassVisitor.ThinMethod> possibleTargetMethods = this.getPossibleTargetMethods(bridgeMethod);
        if (possibleTargetMethods.isEmpty()) {
            return null;
        }
        BridgeMethodClassVisitor bmcv = new BridgeMethodClassVisitor();
        new ClassReader(this.classBytes).accept(bmcv, 4);
        Map<String, String> bridgeMethodMap = bmcv.getBridgeTargetMethods();
        String targetMethod = bridgeMethodMap.get(bridgeMethod.name() + bridgeMethod.descriptor());
        if (targetMethod == null) {
            return null;
        }
        for (ThinClassVisitor.ThinMethod possibleTargetMethod : possibleTargetMethods) {
            if (!targetMethod.equals(possibleTargetMethod.name() + possibleTargetMethod.descriptor())) continue;
            return possibleTargetMethod;
        }
        logger.warn("could not find match for bridge method in {}: {}", (Object)this.className, (Object)bridgeMethod);
        return null;
    }

    private List<ThinClassVisitor.ThinMethod> getPossibleTargetMethods(ThinClassVisitor.ThinMethod bridgeMethod) {
        ArrayList<ThinClassVisitor.ThinMethod> possibleTargetMethods = Lists.newArrayList();
        for (ThinClassVisitor.ThinMethod possibleTargetMethod : this.thinClass.nonBridgeMethods()) {
            if (!possibleTargetMethod.name().equals(bridgeMethod.name())) continue;
            Type[] bridgeMethodParamTypes = Type.getArgumentTypes(bridgeMethod.descriptor());
            Type[] possibleTargetMethodParamTypes = Type.getArgumentTypes(possibleTargetMethod.descriptor());
            if (possibleTargetMethodParamTypes.length != bridgeMethodParamTypes.length) continue;
            possibleTargetMethods.add(possibleTargetMethod);
        }
        return possibleTargetMethods;
    }

    private List<AnalyzedMethod> getMethodsThatOnlyNowFulfillAdvice(AnalyzedClass analyzedClass) throws ClassNotFoundException, IOException {
        if (analyzedClass.isAbstract()) {
            return ImmutableList.of();
        }
        Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets = this.getInheritedInterfaceMethodsWithAdvice();
        if (matchingAdvisorSets.isEmpty()) {
            return ImmutableList.of();
        }
        for (AnalyzedMethod analyzedMethod : analyzedClass.analyzedMethods()) {
            matchingAdvisorSets.remove(AnalyzedMethodKey.wrap(analyzedMethod));
        }
        if (matchingAdvisorSets.isEmpty()) {
            return ImmutableList.of();
        }
        this.removeAdviceAlreadyWovenIntoSuperClass(matchingAdvisorSets);
        if (matchingAdvisorSets.isEmpty()) {
            return ImmutableList.of();
        }
        this.removeMethodsThatWouldOverridePublicFinalMethodsFromSuperClass(matchingAdvisorSets);
        this.removeMethodsThatAreNotImplementedInSuperClass(matchingAdvisorSets);
        ArrayList<AnalyzedMethod> methodsThatOnlyNowFulfillAdvice = Lists.newArrayList();
        for (Map.Entry<AnalyzedMethodKey, Set<Advice>> entry : matchingAdvisorSets.entrySet()) {
            Set<Advice> advisors = entry.getValue();
            if (advisors.isEmpty()) continue;
            AnalyzedMethod inheritedMethod = Preconditions.checkNotNull(entry.getKey().analyzedMethod());
            methodsThatOnlyNowFulfillAdvice.add(ImmutableAnalyzedMethod.builder().copyFrom(inheritedMethod).advisors(advisors).build());
        }
        return methodsThatOnlyNowFulfillAdvice;
    }

    private Map<AnalyzedMethodKey, Set<Advice>> getInheritedInterfaceMethodsWithAdvice() {
        HashMap<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets = Maps.newHashMap();
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            for (AnalyzedMethod superAnalyzedMethod : superAnalyzedClass.analyzedMethods()) {
                AnalyzedMethodKey key = AnalyzedMethodKey.wrap(superAnalyzedMethod);
                HashSet<Advice> matchingAdvisorSet = (HashSet<Advice>)matchingAdvisorSets.get(key);
                if (matchingAdvisorSet == null) {
                    matchingAdvisorSet = Sets.newHashSet();
                }
                matchingAdvisorSet.addAll(superAnalyzedMethod.advisors());
                for (Advice advice : superAnalyzedMethod.subTypeRestrictedAdvisors()) {
                    if (!ClassAnalyzer.isSubTypeRestrictionMatch(advice, this.superClassNames)) continue;
                    matchingAdvisorSet.add(advice);
                }
                if (matchingAdvisorSet.isEmpty()) continue;
                matchingAdvisorSets.put(key, matchingAdvisorSet);
            }
        }
        return matchingAdvisorSets;
    }

    private void removeAdviceAlreadyWovenIntoSuperClass(Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets) {
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            for (AnalyzedMethod superAnalyzedMethod : superAnalyzedClass.analyzedMethods()) {
                AnalyzedMethodKey key;
                Set<Advice> matchingAdvisorSet;
                if (Modifier.isAbstract(superAnalyzedMethod.modifiers()) || (matchingAdvisorSet = matchingAdvisorSets.get(key = AnalyzedMethodKey.wrap(superAnalyzedMethod))) == null) continue;
                matchingAdvisorSet.removeAll(superAnalyzedMethod.advisors());
                if (!matchingAdvisorSet.isEmpty()) continue;
                matchingAdvisorSets.remove(key);
            }
        }
    }

    private void removeMethodsThatWouldOverridePublicFinalMethodsFromSuperClass(Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets) {
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            for (PublicFinalMethod publicFinalMethod : superAnalyzedClass.publicFinalMethods()) {
                ImmutableAnalyzedMethodKey key = ImmutableAnalyzedMethodKey.builder().name(publicFinalMethod.name()).addAllParameterTypes(publicFinalMethod.parameterTypes()).build();
                Set<Advice> value = matchingAdvisorSets.remove(key);
                if (value == null || value.isEmpty()) continue;
                this.logOverridePublicFinalMethodInfo(superAnalyzedClass, publicFinalMethod);
            }
        }
    }

    private void removeMethodsThatAreNotImplementedInSuperClass(Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets) throws ClassNotFoundException, IOException {
        HashSet<AnalyzedMethodKey> superAnalyzedMethodKeys = Sets.newHashSet();
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            superAnalyzedMethodKeys.addAll(ClassAnalyzer.getNonAbstractMethods(superAnalyzedClass.name(), this.loader));
        }
        Iterator<AnalyzedMethodKey> i = matchingAdvisorSets.keySet().iterator();
        while (i.hasNext()) {
            AnalyzedMethodKey analyzedMethodKey = i.next();
            if (superAnalyzedMethodKeys.contains(analyzedMethodKey)) continue;
            i.remove();
        }
    }

    private void logOverridePublicFinalMethodInfo(AnalyzedClass superAnalyzedClass, PublicFinalMethod publicFinalMethod) {
        String format = "Not able to override and instrument final method {}.{}({}) which is being used by a subclass {} to implement one or more instrumented interfaces";
        String arg1 = superAnalyzedClass.name();
        String arg2 = publicFinalMethod.name();
        String arg3 = Joiner.on(", ").join(publicFinalMethod.parameterTypes());
        String arg4 = this.className;
        if (superAnalyzedClass.name().equals("org.jooq.tools.jdbc.JDBC41ResultSet")) {
            logger.debug(format, arg1, arg2, arg3, arg4);
        } else {
            logger.info(format, arg1, arg2, arg3, arg4);
        }
    }

    private static ImmutableList<ShimType> getMatchedShimTypes(List<ShimType> shimTypes, String className, List<AnalyzedClass> superAnalyzedHierarchy, List<AnalyzedClass> interfaceAnalyzedHierarchy) {
        HashSet<ShimType> matchedShimTypes = Sets.newHashSet();
        for (ShimType shimType : shimTypes) {
            if (!shimType.targets().contains(className)) continue;
            matchedShimTypes.add(shimType);
        }
        for (AnalyzedClass interfaceAnalyzedClass : interfaceAnalyzedHierarchy) {
            matchedShimTypes.addAll(interfaceAnalyzedClass.shimTypes());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedHierarchy) {
            if (superAnalyzedClass.isInterface()) continue;
            matchedShimTypes.removeAll(superAnalyzedClass.shimTypes());
        }
        return ImmutableList.copyOf(matchedShimTypes);
    }

    private static MatchedMixinTypes getMatchedMixinTypes(List<MixinType> mixinTypes, String className, @Nullable Class<?> classBeingRedefined, List<AnalyzedClass> superAnalyzedHierarchy, List<AnalyzedClass> interfaceAnalyzedHierarchy) {
        HashSet<MixinType> matchedMixinTypes = Sets.newHashSet();
        for (MixinType mixinType : mixinTypes) {
            if (!mixinType.targets().contains(className)) continue;
            matchedMixinTypes.add(mixinType);
        }
        for (AnalyzedClass interfaceAnalyzedClass : interfaceAnalyzedHierarchy) {
            matchedMixinTypes.addAll(interfaceAnalyzedClass.mixinTypes());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedHierarchy) {
            matchedMixinTypes.addAll(superAnalyzedClass.nonReweavableMixinTypes());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedHierarchy) {
            if (superAnalyzedClass.isInterface()) continue;
            matchedMixinTypes.removeAll(superAnalyzedClass.mixinTypes());
        }
        ArrayList<MixinType> nonReweavableMatchedMixinTypes = Lists.newArrayList();
        if (classBeingRedefined != null) {
            HashSet<String> interfaceNames = Sets.newHashSet();
            for (Class<?> iface : classBeingRedefined.getInterfaces()) {
                interfaceNames.add(iface.getName());
            }
            Iterator i = matchedMixinTypes.iterator();
            block5: while (i.hasNext()) {
                MixinType matchedMixinType = (MixinType)i.next();
                for (Type mixinInterface : matchedMixinType.interfaces()) {
                    if (interfaceNames.contains(mixinInterface.getClassName())) continue;
                    logger.debug("not reweaving {} because cannot add mixin type: {}", (Object)ClassNames.fromInternalName(className), (Object)mixinInterface.getClassName());
                    nonReweavableMatchedMixinTypes.add(matchedMixinType);
                    i.remove();
                    continue block5;
                }
            }
        }
        return ImmutableMatchedMixinTypes.builder().addAllReweavable(matchedMixinTypes).addAllNonReweavable(nonReweavableMatchedMixinTypes).build();
    }

    private static boolean hasMainOrPossibleProcrunStartMethod(List<ThinClassVisitor.ThinMethod> methods) {
        for (ThinClassVisitor.ThinMethod method : methods) {
            if (!Modifier.isPublic(method.access()) || !Modifier.isStatic(method.access()) || !method.name().equals("main") && !method.name().startsWith("start") || !method.descriptor().equals("([Ljava/lang/String;)V")) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getEjbRemoteInterfaces(ThinClassVisitor.ThinClass thinClass, List<AnalyzedClass> superAnalyzedClasses) {
        HashSet<String> ejbRemoteInterfaces = Sets.newHashSet();
        for (Type ejbRemoteInterface : thinClass.ejbRemoteInterfaces()) {
            ejbRemoteInterfaces.add(ejbRemoteInterface.getClassName());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedClasses) {
            if (!superAnalyzedClass.isInterface() || !superAnalyzedClass.ejbRemote()) continue;
            ejbRemoteInterfaces.add(superAnalyzedClass.name());
        }
        return ejbRemoteInterfaces;
    }

    private static List<AnalyzedClass> hack(ThinClassVisitor.ThinClass thinClass, ClassLoader loader, List<AnalyzedClass> superAnalyzedClasses, Set<String> ejbRemoteInterfaces) {
        HashMap<String, List<String>> superInterfaceNames = Maps.newHashMap();
        for (AnalyzedClass analyzedClass : superAnalyzedClasses) {
            if (!analyzedClass.isInterface()) continue;
            superInterfaceNames.put(analyzedClass.name(), analyzedClass.interfaceNames());
        }
        HashMap<String, String> interfaceNamesToInstrument = Maps.newHashMap();
        for (String string : ejbRemoteInterfaces) {
            ClassAnalyzer.addToInterfaceNamesToInstrument(string, superInterfaceNames, interfaceNamesToInstrument, string);
        }
        ArrayList<InstrumentationConfig> arrayList = Lists.newArrayList();
        for (Map.Entry entry : interfaceNamesToInstrument.entrySet()) {
            Object shortClassName = (String)entry.getValue();
            int index = ((String)shortClassName).lastIndexOf(46);
            if (index != -1) {
                shortClassName = ((String)shortClassName).substring(index + 1);
            }
            if ((index = ((String)shortClassName).lastIndexOf(36)) != -1) {
                shortClassName = ((String)shortClassName).substring(index + 1);
            }
            arrayList.add(ImmutableInstrumentationConfig.builder().className((String)entry.getKey()).subTypeRestriction(ClassNames.fromInternalName(thinClass.name())).methodName("*").addMethodParameterTypes("..").captureKind(AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION).transactionType("Web").transactionNameTemplate("EJB remote: " + (String)shortClassName + "#{{methodName}}").traceEntryMessageTemplate("EJB remote: " + (String)entry.getValue() + ".{{methodName}}()").timerName("ejb remote").alreadyInTransactionBehavior(AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY).build());
        }
        ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> immutableMap = AdviceGenerator.createAdvisors(arrayList, null, false, false);
        try {
            ClassLoaders.defineClasses(immutableMap.values(), loader);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        HashMap<String, Advice> hashMap = Maps.newHashMap();
        for (Advice advice : immutableMap.keySet()) {
            hashMap.put(advice.pointcut().className(), advice);
        }
        ArrayList<AnalyzedClass> ejbHackedSuperAnalyzedClasses = Lists.newArrayList();
        for (AnalyzedClass superAnalyzedClass : superAnalyzedClasses) {
            Advice advice = (Advice)hashMap.get(superAnalyzedClass.name());
            if (advice == null) {
                ejbHackedSuperAnalyzedClasses.add(superAnalyzedClass);
                continue;
            }
            ImmutableAnalyzedClass.Builder builder = ImmutableAnalyzedClass.builder().copyFrom(superAnalyzedClass);
            ArrayList<ImmutableAnalyzedMethod> analyzedMethods = Lists.newArrayList();
            for (AnalyzedMethod analyzedMethod : superAnalyzedClass.analyzedMethods()) {
                analyzedMethods.add(ImmutableAnalyzedMethod.builder().copyFrom(analyzedMethod).addSubTypeRestrictedAdvisors(advice).build());
            }
            builder.analyzedMethods(analyzedMethods);
            ejbHackedSuperAnalyzedClasses.add(builder.build());
        }
        return ejbHackedSuperAnalyzedClasses;
    }

    private static void addToInterfaceNamesToInstrument(String interfaceName, Map<String, List<String>> superInterfaceNamesMap, Map<String, String> interfaceNamesToInstrument, String ejbRemoteInterface) {
        interfaceNamesToInstrument.put(interfaceName, ejbRemoteInterface);
        List<String> superInterfaceNames = superInterfaceNamesMap.get(interfaceName);
        if (superInterfaceNames != null) {
            for (String superInterfaceName : superInterfaceNames) {
                ClassAnalyzer.addToInterfaceNamesToInstrument(superInterfaceName, superInterfaceNamesMap, interfaceNamesToInstrument, ejbRemoteInterface);
            }
        }
    }

    private static boolean hasSuperAdvice(List<AnalyzedClass> superAnalyzedClasses) {
        for (AnalyzedClass superAnalyzedClass : superAnalyzedClasses) {
            if (superAnalyzedClass.analyzedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubTypeRestrictionMatch(Advice advice, Set<String> superClassNames) {
        Pattern pointcutSubTypeRestrictionPattern = advice.pointcutSubTypeRestrictionPattern();
        if (pointcutSubTypeRestrictionPattern == null) {
            String subTypeRestriction = advice.pointcut().subTypeRestriction();
            return subTypeRestriction.isEmpty() || superClassNames.contains(subTypeRestriction);
        }
        for (String superClassName : superClassNames) {
            if (!pointcutSubTypeRestrictionPattern.matcher(superClassName).matches()) continue;
            return true;
        }
        return false;
    }

    static List<Advice> sortAdvisors(Collection<Advice> matchingAdvisors) {
        switch (matchingAdvisors.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return Lists.newArrayList(matchingAdvisors);
            }
        }
        return Advice.ordering.sortedCopy(matchingAdvisors);
    }

    private static List<AnalyzedMethodKey> getNonAbstractMethods(String className, @Nullable ClassLoader loader) throws ClassNotFoundException, IOException {
        String path = ClassNames.toInternalName(className) + ".class";
        URL url = loader == null ? ClassLoader.getSystemResource(path) : loader.getResource(path);
        if (url == null) {
            return ClassAnalyzer.getNonAbstractMethodsPlanB(className, loader);
        }
        byte[] bytes = Resources.toByteArray(url);
        NonAbstractMethodClassVisitor accv = new NonAbstractMethodClassVisitor();
        new ClassReader(bytes).accept(accv, 5);
        return accv.analyzedMethodKeys;
    }

    private static List<AnalyzedMethodKey> getNonAbstractMethodsPlanB(String className, @Nullable ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, false, loader);
        ArrayList<AnalyzedMethodKey> analyzedMethodKeys = Lists.newArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            ImmutableAnalyzedMethodKey.Builder builder = ImmutableAnalyzedMethodKey.builder().name(method.getName());
            for (Class<?> parameterType : method.getParameterTypes()) {
                builder.addParameterTypes(parameterType.getName());
            }
            analyzedMethodKeys.add(builder.build());
        }
        return analyzedMethodKeys;
    }

    private static class NonAbstractMethodClassVisitor
    extends ClassVisitor {
        private List<AnalyzedMethodKey> analyzedMethodKeys = Lists.newArrayList();

        private NonAbstractMethodClassVisitor() {
            super(458752);
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            if (!Modifier.isAbstract(access)) {
                ImmutableAnalyzedMethodKey.Builder builder = ImmutableAnalyzedMethodKey.builder().name(name);
                for (Type type : Type.getArgumentTypes(descriptor)) {
                    builder.addParameterTypes(type.getClassName());
                }
                this.analyzedMethodKeys.add(builder.build());
            }
            return null;
        }
    }

    private static class BridgeMethodClassVisitor
    extends ClassVisitor {
        private final Map<String, String> bridgeTargetMethods = Maps.newHashMap();

        private BridgeMethodClassVisitor() {
            super(458752);
        }

        public Map<String, String> getBridgeTargetMethods() {
            return this.bridgeTargetMethods;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            if ((access & 0x40) == 0) {
                return null;
            }
            return new BridgeMethodVisitor(name, descriptor);
        }

        private class BridgeMethodVisitor
        extends MethodVisitor {
            private String bridgeMethodName;
            private String bridgeMethodDesc;
            private int bridgeMethodParamCount;
            private boolean found;

            private BridgeMethodVisitor(String bridgeMethodName, String bridgeMethodDesc) {
                super(458752);
                this.bridgeMethodName = bridgeMethodName;
                this.bridgeMethodDesc = bridgeMethodDesc;
                this.bridgeMethodParamCount = Type.getArgumentTypes(bridgeMethodDesc).length;
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean itf) {
                if (this.found) {
                    return;
                }
                if (!name.equals(this.bridgeMethodName)) {
                    return;
                }
                if (Type.getArgumentTypes(descriptor).length != this.bridgeMethodParamCount) {
                    return;
                }
                if (opcode == 183) {
                    return;
                }
                BridgeMethodClassVisitor.this.bridgeTargetMethods.put(this.bridgeMethodName + this.bridgeMethodDesc, name + descriptor);
                this.found = true;
            }
        }
    }

    @Value.Immutable
    static interface MatchedMixinTypes {
        public List<MixinType> reweavable();

        public List<MixinType> nonReweavable();
    }

    @Value.Immutable
    static interface MatchedShimTypes {
        public List<ShimType> reweavable();

        public List<ShimType> nonReweavable();
    }

    @Value.Immutable
    static abstract class AnalyzedMethodKey {
        AnalyzedMethodKey() {
        }

        abstract String name();

        abstract ImmutableList<String> parameterTypes();

        @Value.Auxiliary
        @Nullable
        abstract AnalyzedMethod analyzedMethod();

        private static AnalyzedMethodKey wrap(AnalyzedMethod analyzedMethod) {
            return ImmutableAnalyzedMethodKey.builder().name(analyzedMethod.name()).addAllParameterTypes(analyzedMethod.parameterTypes()).analyzedMethod(analyzedMethod).build();
        }
    }
}

