/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.weaving.MethodModifier;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.ImmutableAdviceMatcher;
import org.immutables.value.Value;

@Value.Immutable
@Styles.AllParameters
abstract class AdviceMatcher {
    private static final Logger logger = LoggerFactory.getLogger(AdviceMatcher.class);

    AdviceMatcher() {
    }

    static ImmutableList<AdviceMatcher> getAdviceMatchers(String className, List<String> classAnnotations, Collection<String> superClassNames, List<Advice> advisors) {
        ArrayList<ImmutableAdviceMatcher> adviceMatchers = Lists.newArrayList();
        for (Advice advice : advisors) {
            if (!AdviceMatcher.isClassMatch(className, classAnnotations, superClassNames, advice)) continue;
            adviceMatchers.add(ImmutableAdviceMatcher.of(advice));
        }
        return ImmutableList.copyOf(adviceMatchers);
    }

    abstract Advice advice();

    boolean isMethodLevelMatch(String methodName, List<String> methodAnnotations, List<Type> parameterTypes, Type returnType, int modifiers) {
        if (!(this.isMethodNameMatch(methodName) && AdviceMatcher.isAnnotationMatch(methodAnnotations, this.advice().pointcutMethodAnnotationPattern(), this.advice().pointcut().methodAnnotation()) && this.isMethodParameterTypesMatch(parameterTypes))) {
            return false;
        }
        return this.isMethodReturnMatch(returnType) && this.isMethodModifiersMatch(modifiers);
    }

    private boolean isMethodNameMatch(String methodName) {
        if (methodName.equals("<clinit>")) {
            return false;
        }
        Pattern pointcutMethodNamePattern = this.advice().pointcutMethodNamePattern();
        if (pointcutMethodNamePattern != null) {
            return !methodName.equals("<init>") && pointcutMethodNamePattern.matcher(methodName).matches();
        }
        String pointcutMethodName = this.advice().pointcut().methodName();
        return pointcutMethodName.isEmpty() || pointcutMethodName.equals(methodName);
    }

    private boolean isMethodParameterTypesMatch(List<Type> parameterTypes) {
        List<Object> pointcutMethodParameterTypes = this.advice().pointcutMethodParameterTypes();
        for (int i = 0; i < pointcutMethodParameterTypes.size(); ++i) {
            Object pointcutMethodParameterType = pointcutMethodParameterTypes.get(i);
            if (pointcutMethodParameterType.equals("..")) {
                if (i != pointcutMethodParameterTypes.size() - 1) {
                    logger.warn("'..' can only be used at the end of methodParameterTypes");
                    return false;
                }
                return true;
            }
            if (parameterTypes.size() == i) {
                return false;
            }
            if (AdviceMatcher.isMethodParameterTypeMatch(pointcutMethodParameterType, parameterTypes.get(i))) continue;
            return false;
        }
        return parameterTypes.size() == pointcutMethodParameterTypes.size();
    }

    private boolean isMethodReturnMatch(Type returnType) {
        String pointcutMethodReturn = this.advice().pointcut().methodReturnType();
        return pointcutMethodReturn.isEmpty() || pointcutMethodReturn.equals(returnType.getClassName());
    }

    private boolean isMethodModifiersMatch(int modifiers) {
        for (MethodModifier methodModifier : this.advice().pointcut().methodModifiers()) {
            if (AdviceMatcher.isMethodModifierMatch(methodModifier, modifiers)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodParameterTypeMatch(Object pointcutMethodParameterType, Type parameterType) {
        String className = parameterType.getClassName();
        if (pointcutMethodParameterType instanceof String) {
            return pointcutMethodParameterType.equals(className);
        }
        return ((Pattern)pointcutMethodParameterType).matcher(className).matches();
    }

    private static boolean isMethodModifierMatch(MethodModifier methodModifier, int modifiers) {
        switch (methodModifier) {
            case PUBLIC: {
                return Modifier.isPublic(modifiers);
            }
            case STATIC: {
                return Modifier.isStatic(modifiers);
            }
            case NOT_STATIC: {
                return !Modifier.isStatic(modifiers);
            }
        }
        return false;
    }

    private static boolean isClassMatch(String className, List<String> classAnnotations, Collection<String> superClassNames, Advice advice) {
        if (!AdviceMatcher.isAnnotationMatch(classAnnotations, advice.pointcutClassAnnotationPattern(), advice.pointcut().classAnnotation())) {
            return false;
        }
        if (!AdviceMatcher.isClassNameMatch(className, advice)) {
            return false;
        }
        Pattern pointcutSuperTypeRestrictionPattern = advice.pointcutSuperTypeRestrictionPattern();
        if (pointcutSuperTypeRestrictionPattern != null) {
            for (String superClassName : superClassNames) {
                if (!pointcutSuperTypeRestrictionPattern.matcher(superClassName).matches()) continue;
                return true;
            }
            return false;
        }
        String superTypeRestriction = advice.pointcut().superTypeRestriction();
        return superTypeRestriction.isEmpty() || superClassNames.contains(superTypeRestriction);
    }

    private static boolean isClassNameMatch(String className, Advice advice) {
        Pattern classNamePattern = advice.pointcutClassNamePattern();
        if (classNamePattern != null) {
            return classNamePattern.matcher(className).matches();
        }
        String pointcutClassName = advice.pointcut().className();
        return pointcutClassName.isEmpty() || pointcutClassName.equals(className);
    }

    private static boolean isAnnotationMatch(List<String> annotations, @Nullable Pattern pattern, String strictMatch) {
        for (String annotation : annotations) {
            annotation = annotation.replace('/', '.').substring(1, annotation.length() - 1);
            if (pattern != null && pattern.matcher(annotation).matches()) {
                return true;
            }
            if (!annotation.equals(strictMatch)) continue;
            return true;
        }
        return strictMatch.isEmpty();
    }
}

