/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.weaving.ClassLoaders;
import org.immutables.value.Value;

@Value.Immutable
abstract class Advice {
    static final Ordering<Advice> ordering = new AdviceOrdering();

    Advice() {
    }

    abstract Pointcut pointcut();

    abstract Type adviceType();

    @Nullable
    abstract Pattern pointcutClassNamePattern();

    @Nullable
    abstract Pattern pointcutClassAnnotationPattern();

    @Nullable
    abstract Pattern pointcutSubTypeRestrictionPattern();

    @Nullable
    abstract Pattern pointcutSuperTypeRestrictionPattern();

    @Nullable
    abstract Pattern pointcutMethodNamePattern();

    @Nullable
    abstract Pattern pointcutMethodAnnotationPattern();

    abstract List<Object> pointcutMethodParameterTypes();

    @Nullable
    abstract Type travelerType();

    @Nullable
    abstract Method isEnabledAdvice();

    @Nullable
    abstract Method onBeforeAdvice();

    @Nullable
    abstract Method onReturnAdvice();

    @Nullable
    abstract Method onThrowAdvice();

    @Nullable
    abstract Method onAfterAdvice();

    abstract ImmutableList<AdviceParameter> isEnabledParameters();

    abstract ImmutableList<AdviceParameter> onBeforeParameters();

    abstract ImmutableList<AdviceParameter> onReturnParameters();

    abstract ImmutableList<AdviceParameter> onThrowParameters();

    abstract ImmutableList<AdviceParameter> onAfterParameters();

    abstract boolean hasBindThreadContext();

    abstract boolean hasBindOptionalThreadContext();

    abstract boolean reweavable();

    @Nullable
    abstract Advice nonBootstrapLoaderAdvice();

    @Nullable
    abstract ClassLoaders.LazyDefinedClass nonBootstrapLoaderAdviceClass();

    @Value.Derived
    ImmutableSet<Type> classMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(Advice.getClassMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    @Value.Derived
    ImmutableSet<Type> methodMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(Advice.getMethodMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    private static Set<Type> getClassMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.CLASS_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    private static Set<Type> getMethodMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.METHOD_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    @Value.Immutable
    static interface AdviceParameter {
        public ParameterKind kind();

        public Type type();
    }

    private static class AdviceOrdering
    extends Ordering<Advice> {
        private AdviceOrdering() {
        }

        @Override
        public int compare(Advice left, Advice right) {
            int compare = Ints.compare(left.pointcut().order(), right.pointcut().order());
            if (compare != 0) {
                return compare;
            }
            String leftTimerName = left.pointcut().timerName();
            String rightTimerName = right.pointcut().timerName();
            if (leftTimerName.isEmpty() && rightTimerName.isEmpty()) {
                return 0;
            }
            if (leftTimerName.isEmpty()) {
                return 1;
            }
            if (rightTimerName.isEmpty()) {
                return -1;
            }
            return leftTimerName.compareToIgnoreCase(rightTimerName);
        }
    }

    static enum ParameterKind {
        RECEIVER,
        METHOD_ARG,
        METHOD_ARG_ARRAY,
        METHOD_NAME,
        RETURN,
        OPTIONAL_RETURN,
        THROWABLE,
        TRAVELER,
        CLASS_META,
        METHOD_META,
        THREAD_CONTEXT,
        OPTIONAL_THREAD_CONTEXT;

    }
}

