/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class Version {
    public static final String UNKNOWN_VERSION = "unknown";
    private static final Logger logger = LoggerFactory.getLogger(Version.class);

    private Version() {
    }

    public static String getVersion(Class<?> baseClass) {
        Manifest manifest;
        try {
            manifest = Version.getManifest(baseClass);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return UNKNOWN_VERSION;
        }
        return Version.getVersion(manifest);
    }

    public static String getVersion(@Nullable URL manifestURL) {
        Manifest manifest;
        try {
            manifest = Version.getManifest(manifestURL);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return UNKNOWN_VERSION;
        }
        return Version.getVersion(manifest);
    }

    @Nullable
    static Manifest getManifest(Class<?> clazz) throws IOException {
        URL classURL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (classURL == null) {
            logger.warn("url for class is unexpectedly null: {}", (Object)clazz);
            return null;
        }
        String externalForm = classURL.toExternalForm();
        if (!externalForm.startsWith("jar:")) {
            return null;
        }
        URL manifestURL = new URL(externalForm.substring(0, externalForm.lastIndexOf(33)) + "!/META-INF/MANIFEST.MF");
        return Version.getManifest(manifestURL);
    }

    @Nullable
    private static Manifest getManifest(@Nullable URL url) throws IOException {
        if (url == null) {
            return null;
        }
        Closer closer = Closer.create();
        try {
            InputStream manifestIn = closer.register(url.openStream());
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    static String getVersion(@Nullable Manifest manifest) {
        if (manifest == null) {
            logger.debug("could not locate META-INF/MANIFEST.MF file");
            return UNKNOWN_VERSION;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String version = mainAttributes.getValue("Implementation-Version");
        if (version == null) {
            logger.warn("could not find Implementation-Version attribute in META-INF/MANIFEST.MF file");
            return UNKNOWN_VERSION;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return Version.getSnapshotVersion(version, mainAttributes);
        }
        String timestamp = mainAttributes.getValue("Build-Time");
        if (timestamp == null) {
            logger.warn("could not find Build-Time attribute in META-INF/MANIFEST.MF file");
            return version;
        }
        return version + ", built " + timestamp;
    }

    private static String getSnapshotVersion(String version, Attributes mainAttributes) {
        String timestamp;
        StringBuilder snapshotVersion = new StringBuilder(version);
        String commit = mainAttributes.getValue("Build-Commit");
        if (commit != null && !commit.equals("[none]")) {
            if (commit.length() == 40) {
                snapshotVersion.append(", commit ");
                snapshotVersion.append(commit.substring(0, 10));
            } else {
                logger.warn("invalid Build-Commit attribute in META-INF/MANIFEST.MF file, should be a 40 character git commit hash");
            }
        }
        if ((timestamp = mainAttributes.getValue("Build-Time")) == null) {
            logger.warn("could not find Build-Time attribute in META-INF/MANIFEST.MF file");
            return snapshotVersion.toString();
        }
        snapshotVersion.append(", built ");
        snapshotVersion.append(timestamp);
        return snapshotVersion.toString();
    }
}

