/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.DefaultIndenter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ContainerNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.GuavaModule;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;

public class ObjectMappers {
    public static final String NEWLINE;

    private ObjectMappers() {
    }

    public static ObjectMapper create(Module ... extraModules) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Boolean.TYPE, new BooleanSerializer(Boolean.class));
        module.addSerializer(Enum.class, new EnumSerializer(Enum.class));
        module.setDeserializerModifier(new EnumDeserializerModifier());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(module);
        mapper.registerModule(new GuavaModule());
        for (Module extraModule : extraModules) {
            mapper.registerModule(extraModule);
        }
        mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return mapper;
    }

    public static PrettyPrinter getPrettyPrinter() {
        CustomPrettyPrinter prettyPrinter = new CustomPrettyPrinter();
        prettyPrinter.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        return prettyPrinter;
    }

    public static void stripEmptyContainerNodes(ObjectNode objectNode) {
        Iterator<Map.Entry<String, JsonNode>> i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry<String, JsonNode> entry = i.next();
            JsonNode value = entry.getValue();
            if (!(value instanceof ContainerNode) || ((ContainerNode)value).size() != 0) continue;
            i.remove();
        }
    }

    static {
        String newline = StandardSystemProperty.LINE_SEPARATOR.value();
        NEWLINE = newline == null ? "\n" : newline;
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        private CustomPrettyPrinter() {
        }

        @Override
        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(": ");
        }
    }

    private static class EnumDeserializerModifier
    extends BeanDeserializerModifier {
        private EnumDeserializerModifier() {
        }

        public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsonDeserializer<Enum>(){

                @Override
                public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                    Class<Enum> rawClass = type.getRawClass().asSubclass(Enum.class);
                    return Enum.valueOf(rawClass, jp.getValueAsString().replace('-', '_').toUpperCase(Locale.ENGLISH));
                }
            };
        }
    }

    private static class EnumSerializer
    extends StdSerializer<Enum> {
        private EnumSerializer(Class<Enum> t) {
            super(t);
        }

        @Override
        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name().replace('_', '-').toLowerCase(Locale.ENGLISH));
        }
    }

    private static class BooleanSerializer
    extends NonTypedScalarSerializerBase<Boolean> {
        private BooleanSerializer(Class<Boolean> t) {
            super(t);
        }

        @Override
        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBoolean(value);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("boolean", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectBooleanFormat(typeHint);
            }
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Boolean value) {
            return value == null || value == false;
        }
    }
}

