/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.List;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableTransactionNameSummary;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.immutables.value.Value;

public class TransactionNameSummaryCollector {
    private static final Ordering<TransactionNameSummary> orderingByTotalTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalDurationNanos(), left.totalDurationNanos());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByAverageTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalDurationNanos() / (double)right.transactionCount(), left.totalDurationNanos() / (double)left.transactionCount());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByTransactionCountDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Longs.compare(right.transactionCount(), left.transactionCount());
        }
    };
    private final Map<String, MutableTransactionNameSummary> transactionNameSummaries = Maps.newHashMap();
    private long lastCaptureTime;

    public void collect(String transactionName, double totalDurationNanos, long transactionCount, long captureTime) {
        MutableTransactionNameSummary mts = this.transactionNameSummaries.get(transactionName);
        if (mts == null) {
            mts = new MutableTransactionNameSummary();
            this.transactionNameSummaries.put(transactionName, mts);
        }
        MutableTransactionNameSummary mutableTransactionNameSummary = mts;
        mutableTransactionNameSummary.totalDurationNanos = mutableTransactionNameSummary.totalDurationNanos + totalDurationNanos;
        mutableTransactionNameSummary = mts;
        mutableTransactionNameSummary.transactionCount = mutableTransactionNameSummary.transactionCount + transactionCount;
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public Result<TransactionNameSummary> getResult(SummarySortOrder sortOrder, int limit) {
        List<TransactionNameSummary> summaries = Lists.newArrayList();
        for (Map.Entry<String, MutableTransactionNameSummary> entry : this.transactionNameSummaries.entrySet()) {
            summaries.add(ImmutableTransactionNameSummary.builder().transactionName(entry.getKey()).totalDurationNanos(entry.getValue().totalDurationNanos).transactionCount(entry.getValue().transactionCount).build());
        }
        if ((summaries = TransactionNameSummaryCollector.sortTransactionNameSummaries(summaries, sortOrder)).size() > limit) {
            return new Result<TransactionNameSummary>(summaries.subList(0, limit), true);
        }
        return new Result<TransactionNameSummary>(summaries, false);
    }

    private static List<TransactionNameSummary> sortTransactionNameSummaries(Iterable<TransactionNameSummary> transactionNameSummaries, SummarySortOrder sortOrder) {
        switch (sortOrder) {
            case TOTAL_TIME: {
                return orderingByTotalTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case AVERAGE_TIME: {
                return orderingByAverageTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case THROUGHPUT: {
                return orderingByTransactionCountDesc.immutableSortedCopy(transactionNameSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    private static class MutableTransactionNameSummary {
        private double totalDurationNanos;
        private long transactionCount;

        private MutableTransactionNameSummary() {
        }
    }

    @Value.Immutable
    public static interface TransactionNameSummary {
        public String transactionName();

        public double totalDurationNanos();

        public long transactionCount();
    }

    public static enum SummarySortOrder {
        TOTAL_TIME,
        AVERAGE_TIME,
        THROUGHPUT;

    }
}

