/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableOverallSummary;
import org.immutables.value.Value;

public class OverallSummaryCollector {
    private double totalDurationNanos;
    private long transactionCount;
    private long lastCaptureTime;

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public OverallSummary getOverallSummary() {
        return ImmutableOverallSummary.builder().totalDurationNanos(this.totalDurationNanos).transactionCount(this.transactionCount).build();
    }

    public void mergeSummary(double totalDurationNanos, long transactionCount, long captureTime) {
        this.totalDurationNanos += totalDurationNanos;
        this.transactionCount += transactionCount;
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    @Value.Immutable
    public static interface OverallSummary {
        public double totalDurationNanos();

        public long transactionCount();
    }
}

