/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class MutableQuery {
    static final Ordering<MutableQuery> byTotalDurationDesc = new Ordering<MutableQuery>(){

        @Override
        public int compare(MutableQuery left, MutableQuery right) {
            return Doubles.compare(right.getTotalDurationNanos(), left.getTotalDurationNanos());
        }
    };
    private final String type;
    private final String truncatedText;
    @Nullable
    private final String fullTextSha1;
    private double totalDurationNanos;
    private long executionCount;
    private boolean hasTotalRows;
    private long totalRows;

    MutableQuery(String type, String truncatedText, @Nullable String fullTextSha1) {
        this.type = type;
        this.truncatedText = truncatedText;
        this.fullTextSha1 = fullTextSha1;
    }

    public String getType() {
        return this.type;
    }

    public String getTruncatedText() {
        return this.truncatedText;
    }

    @Nullable
    public String getFullTextSha1() {
        return this.fullTextSha1;
    }

    public double getTotalDurationNanos() {
        return this.totalDurationNanos;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public boolean hasTotalRows() {
        return this.hasTotalRows;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    void addToTotalDurationNanos(double totalDurationNanos) {
        this.totalDurationNanos += totalDurationNanos;
    }

    void addToExecutionCount(long executionCount) {
        this.executionCount += executionCount;
    }

    void addToTotalRows(boolean hasTotalRows, long totalRows) {
        if (hasTotalRows) {
            this.hasTotalRows = true;
            this.totalRows += totalRows;
        }
    }

    void add(MutableQuery query) {
        this.addToTotalDurationNanos(query.totalDurationNanos);
        this.addToExecutionCount(query.executionCount);
        this.addToTotalRows(query.hasTotalRows, query.totalRows);
    }
}

