/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="LiveAggregateRepository.OverviewAggregate", generator="Immutables")
@Immutable
public final class ImmutableOverviewAggregate
implements LiveAggregateRepository.OverviewAggregate {
    private final long captureTime;
    private final double totalDurationNanos;
    private final long transactionCount;
    private final boolean asyncTransactions;
    private final ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers;
    private final AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
    @Nullable
    private final AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
    @Nullable
    private final AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
    private final ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers;

    private ImmutableOverviewAggregate(long captureTime, double totalDurationNanos, long transactionCount, boolean asyncTransactions, ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers, AggregateOuterClass.Aggregate.ThreadStats mainThreadStats, @Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer, @Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats, ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers) {
        this.captureTime = captureTime;
        this.totalDurationNanos = totalDurationNanos;
        this.transactionCount = transactionCount;
        this.asyncTransactions = asyncTransactions;
        this.mainThreadRootTimers = mainThreadRootTimers;
        this.mainThreadStats = mainThreadStats;
        this.auxThreadRootTimer = auxThreadRootTimer;
        this.auxThreadStats = auxThreadStats;
        this.asyncTimers = asyncTimers;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="asyncTransactions")
    public boolean asyncTransactions() {
        return this.asyncTransactions;
    }

    @JsonProperty(value="mainThreadRootTimers")
    public ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers() {
        return this.mainThreadRootTimers;
    }

    @Override
    @JsonProperty(value="mainThreadStats")
    public AggregateOuterClass.Aggregate.ThreadStats mainThreadStats() {
        return this.mainThreadStats;
    }

    @Override
    @JsonProperty(value="auxThreadRootTimer")
    @Nullable
    public AggregateOuterClass.Aggregate.Timer auxThreadRootTimer() {
        return this.auxThreadRootTimer;
    }

    @Override
    @JsonProperty(value="auxThreadStats")
    @Nullable
    public AggregateOuterClass.Aggregate.ThreadStats auxThreadStats() {
        return this.auxThreadStats;
    }

    @JsonProperty(value="asyncTimers")
    public ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers() {
        return this.asyncTimers;
    }

    public final ImmutableOverviewAggregate withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutableOverviewAggregate(value, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableOverviewAggregate(this.captureTime, value, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, value, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withAsyncTransactions(boolean value) {
        if (this.asyncTransactions == value) {
            return this;
        }
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, value, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer ... elements) {
        ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, newValue, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withMainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
        if (this.mainThreadRootTimers == elements) {
            return this;
        }
        ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, newValue, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withMainThreadStats(AggregateOuterClass.Aggregate.ThreadStats value) {
        if (this.mainThreadStats == value) {
            return this;
        }
        AggregateOuterClass.Aggregate.ThreadStats newValue = Preconditions.checkNotNull(value, "mainThreadStats");
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, newValue, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withAuxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer value) {
        if (this.auxThreadRootTimer == value) {
            return this;
        }
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, value, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withAuxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats value) {
        if (this.auxThreadStats == value) {
            return this;
        }
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, value, this.asyncTimers);
    }

    public final ImmutableOverviewAggregate withAsyncTimers(AggregateOuterClass.Aggregate.Timer ... elements) {
        ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, newValue);
    }

    public final ImmutableOverviewAggregate withAsyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
        if (this.asyncTimers == elements) {
            return this;
        }
        ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, newValue);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOverviewAggregate && this.equalTo((ImmutableOverviewAggregate)another);
    }

    private boolean equalTo(ImmutableOverviewAggregate another) {
        return this.captureTime == another.captureTime && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.transactionCount == another.transactionCount && this.asyncTransactions == another.asyncTransactions && this.mainThreadRootTimers.equals(another.mainThreadRootTimers) && this.mainThreadStats.equals(another.mainThreadStats) && Objects.equal(this.auxThreadRootTimer, another.auxThreadRootTimer) && Objects.equal(this.auxThreadStats, another.auxThreadStats) && this.asyncTimers.equals(another.asyncTimers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.captureTime);
        h += (h << 5) + Doubles.hashCode(this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode(this.transactionCount);
        h += (h << 5) + Booleans.hashCode(this.asyncTransactions);
        h += (h << 5) + this.mainThreadRootTimers.hashCode();
        h += (h << 5) + this.mainThreadStats.hashCode();
        h += (h << 5) + Objects.hashCode(this.auxThreadRootTimer);
        h += (h << 5) + Objects.hashCode(this.auxThreadStats);
        h += (h << 5) + this.asyncTimers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OverviewAggregate").omitNullValues().add("captureTime", this.captureTime).add("totalDurationNanos", this.totalDurationNanos).add("transactionCount", this.transactionCount).add("asyncTransactions", this.asyncTransactions).add("mainThreadRootTimers", this.mainThreadRootTimers).add("mainThreadStats", this.mainThreadStats).add("auxThreadRootTimer", this.auxThreadRootTimer).add("auxThreadStats", this.auxThreadStats).add("asyncTimers", this.asyncTimers).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOverviewAggregate fromJson(Json json) {
        Builder builder = ImmutableOverviewAggregate.builder();
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        if (json.asyncTransactionsIsSet) {
            builder.asyncTransactions(json.asyncTransactions);
        }
        if (json.mainThreadRootTimers != null) {
            builder.addAllMainThreadRootTimers(json.mainThreadRootTimers);
        }
        if (json.mainThreadStats != null) {
            builder.mainThreadStats(json.mainThreadStats);
        }
        if (json.auxThreadRootTimer != null) {
            builder.auxThreadRootTimer(json.auxThreadRootTimer);
        }
        if (json.auxThreadStats != null) {
            builder.auxThreadStats(json.auxThreadStats);
        }
        if (json.asyncTimers != null) {
            builder.addAllAsyncTimers(json.asyncTimers);
        }
        return builder.build();
    }

    public static ImmutableOverviewAggregate copyOf(LiveAggregateRepository.OverviewAggregate instance) {
        if (instance instanceof ImmutableOverviewAggregate) {
            return (ImmutableOverviewAggregate)instance;
        }
        return ImmutableOverviewAggregate.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveAggregateRepository.OverviewAggregate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_TIME = 1L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 2L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 4L;
        private static final long INIT_BIT_ASYNC_TRANSACTIONS = 8L;
        private static final long INIT_BIT_MAIN_THREAD_STATS = 16L;
        private long initBits = 31L;
        private long captureTime;
        private double totalDurationNanos;
        private long transactionCount;
        private boolean asyncTransactions;
        private ImmutableList.Builder<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers = ImmutableList.builder();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
        private ImmutableList.Builder<AggregateOuterClass.Aggregate.Timer> asyncTimers = ImmutableList.builder();

        private Builder() {
        }

        public final Builder copyFrom(LiveAggregateRepository.OverviewAggregate instance) {
            AggregateOuterClass.Aggregate.ThreadStats auxThreadStatsValue;
            Preconditions.checkNotNull(instance, "instance");
            this.captureTime(instance.captureTime());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.transactionCount(instance.transactionCount());
            this.asyncTransactions(instance.asyncTransactions());
            this.addAllMainThreadRootTimers(instance.mainThreadRootTimers());
            this.mainThreadStats(instance.mainThreadStats());
            AggregateOuterClass.Aggregate.Timer auxThreadRootTimerValue = instance.auxThreadRootTimer();
            if (auxThreadRootTimerValue != null) {
                this.auxThreadRootTimer(auxThreadRootTimerValue);
            }
            if ((auxThreadStatsValue = instance.auxThreadStats()) != null) {
                this.auxThreadStats(auxThreadStatsValue);
            }
            this.addAllAsyncTimers(instance.asyncTimers());
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder asyncTransactions(boolean asyncTransactions) {
            this.asyncTransactions = asyncTransactions;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer element) {
            this.mainThreadRootTimers.add((Object)element);
            return this;
        }

        public final Builder addMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer ... elements) {
            this.mainThreadRootTimers.add(elements);
            return this;
        }

        public final Builder mainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
            this.mainThreadRootTimers = ImmutableList.builder();
            return this.addAllMainThreadRootTimers(elements);
        }

        public final Builder addAllMainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
            this.mainThreadRootTimers.addAll(elements);
            return this;
        }

        public final Builder mainThreadStats(AggregateOuterClass.Aggregate.ThreadStats mainThreadStats) {
            this.mainThreadStats = Preconditions.checkNotNull(mainThreadStats, "mainThreadStats");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder auxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer) {
            this.auxThreadRootTimer = auxThreadRootTimer;
            return this;
        }

        public final Builder auxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats) {
            this.auxThreadStats = auxThreadStats;
            return this;
        }

        public final Builder addAsyncTimers(AggregateOuterClass.Aggregate.Timer element) {
            this.asyncTimers.add((Object)element);
            return this;
        }

        public final Builder addAsyncTimers(AggregateOuterClass.Aggregate.Timer ... elements) {
            this.asyncTimers.add(elements);
            return this;
        }

        public final Builder asyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
            this.asyncTimers = ImmutableList.builder();
            return this.addAllAsyncTimers(elements);
        }

        public final Builder addAllAsyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
            this.asyncTimers.addAll(elements);
            return this;
        }

        public ImmutableOverviewAggregate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOverviewAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.asyncTransactions, (ImmutableList)this.mainThreadRootTimers.build(), this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, (ImmutableList)this.asyncTimers.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transactionCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("asyncTransactions");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("mainThreadStats");
            }
            return "Cannot build OverviewAggregate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiveAggregateRepository.OverviewAggregate", generator="Immutables")
    static final class Json
    implements LiveAggregateRepository.OverviewAggregate {
        long captureTime;
        boolean captureTimeIsSet;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long transactionCount;
        boolean transactionCountIsSet;
        boolean asyncTransactions;
        boolean asyncTransactionsIsSet;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        List<AggregateOuterClass.Aggregate.Timer> asyncTimers = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @JsonProperty(value="asyncTransactions")
        public void setAsyncTransactions(boolean asyncTransactions) {
            this.asyncTransactions = asyncTransactions;
            this.asyncTransactionsIsSet = true;
        }

        @JsonProperty(value="mainThreadRootTimers")
        public void setMainThreadRootTimers(List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers) {
            this.mainThreadRootTimers = mainThreadRootTimers;
        }

        @JsonProperty(value="mainThreadStats")
        public void setMainThreadStats(AggregateOuterClass.Aggregate.ThreadStats mainThreadStats) {
            this.mainThreadStats = mainThreadStats;
        }

        @JsonProperty(value="auxThreadRootTimer")
        public void setAuxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer) {
            this.auxThreadRootTimer = auxThreadRootTimer;
        }

        @JsonProperty(value="auxThreadStats")
        public void setAuxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats) {
            this.auxThreadStats = auxThreadStats;
        }

        @JsonProperty(value="asyncTimers")
        public void setAsyncTimers(List<AggregateOuterClass.Aggregate.Timer> asyncTimers) {
            this.asyncTimers = asyncTimers;
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asyncTransactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggregateOuterClass.Aggregate.ThreadStats mainThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggregateOuterClass.Aggregate.Timer auxThreadRootTimer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggregateOuterClass.Aggregate.ThreadStats auxThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AggregateOuterClass.Aggregate.Timer> asyncTimers() {
            throw new UnsupportedOperationException();
        }
    }
}

