/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="LiveAggregateRepository.AggregateQuery", generator="Immutables")
@Immutable
public final class ImmutableAggregateQuery
implements LiveAggregateRepository.AggregateQuery {
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final long from;
    private final long to;
    private final int rollupLevel;

    private ImmutableAggregateQuery(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.rollupLevel = rollupLevel;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    @Nullable
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="rollupLevel")
    public int rollupLevel() {
        return this.rollupLevel;
    }

    public final ImmutableAggregateQuery withTransactionType(String value) {
        String newValue = Preconditions.checkNotNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableAggregateQuery(newValue, this.transactionName, this.from, this.to, this.rollupLevel);
    }

    public final ImmutableAggregateQuery withTransactionName(@Nullable String value) {
        if (Objects.equal(this.transactionName, value)) {
            return this;
        }
        return new ImmutableAggregateQuery(this.transactionType, value, this.from, this.to, this.rollupLevel);
    }

    public final ImmutableAggregateQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableAggregateQuery(this.transactionType, this.transactionName, value, this.to, this.rollupLevel);
    }

    public final ImmutableAggregateQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableAggregateQuery(this.transactionType, this.transactionName, this.from, value, this.rollupLevel);
    }

    public final ImmutableAggregateQuery withRollupLevel(int value) {
        if (this.rollupLevel == value) {
            return this;
        }
        return new ImmutableAggregateQuery(this.transactionType, this.transactionName, this.from, this.to, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregateQuery && this.equalTo((ImmutableAggregateQuery)another);
    }

    private boolean equalTo(ImmutableAggregateQuery another) {
        return this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && this.rollupLevel == another.rollupLevel;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode(this.from);
        h += (h << 5) + Longs.hashCode(this.to);
        h += (h << 5) + this.rollupLevel;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AggregateQuery").omitNullValues().add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("from", this.from).add("to", this.to).add("rollupLevel", this.rollupLevel).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAggregateQuery fromJson(Json json) {
        Builder builder = ImmutableAggregateQuery.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.rollupLevelIsSet) {
            builder.rollupLevel(json.rollupLevel);
        }
        return builder.build();
    }

    public static ImmutableAggregateQuery copyOf(LiveAggregateRepository.AggregateQuery instance) {
        if (instance instanceof ImmutableAggregateQuery) {
            return (ImmutableAggregateQuery)instance;
        }
        return ImmutableAggregateQuery.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveAggregateRepository.AggregateQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_ROLLUP_LEVEL = 8L;
        private long initBits = 15L;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String transactionType;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String transactionName;
        private long from;
        private long to;
        private int rollupLevel;

        private Builder() {
        }

        public final Builder copyFrom(LiveAggregateRepository.AggregateQuery instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.transactionType(instance.transactionType());
            String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.from(instance.from());
            this.to(instance.to());
            this.rollupLevel(instance.rollupLevel());
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder rollupLevel(int rollupLevel) {
            this.rollupLevel = rollupLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAggregateQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAggregateQuery(this.transactionType, this.transactionName, this.from, this.to, this.rollupLevel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("rollupLevel");
            }
            return "Cannot build AggregateQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiveAggregateRepository.AggregateQuery", generator="Immutables")
    static final class Json
    implements LiveAggregateRepository.AggregateQuery {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String transactionType;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        int rollupLevel;
        boolean rollupLevelIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="rollupLevel")
        public void setRollupLevel(int rollupLevel) {
            this.rollupLevel = rollupLevel;
            this.rollupLevelIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int rollupLevel() {
            throw new UnsupportedOperationException();
        }
    }
}

