/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import java.util.Map;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@Value.Immutable
public abstract class InstrumentationConfig {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationConfig.class);

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String className() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String classAnnotation() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String subTypeRestriction() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String superTypeRestriction() {
        return "";
    }

    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String methodDeclaringClassName() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String methodName() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String methodAnnotation() {
        return "";
    }

    public abstract ImmutableList<String> methodParameterTypes();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String methodReturnType() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<AgentConfigOuterClass.AgentConfig.InstrumentationConfig.MethodModifier> methodModifiers();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String nestingGroup() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public int order() {
        return 0;
    }

    public abstract AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind captureKind();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String transactionType() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String transactionNameTemplate() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String transactionUserTemplate() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Map<String, String> transactionAttributeTemplates();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public abstract Integer transactionSlowThresholdMillis();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public abstract AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior();

    @JsonIgnore
    @Value.Derived
    @Nullable
    public AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected() {
        if (this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION) {
            return MoreObjects.firstNonNull(this.alreadyInTransactionBehavior(), AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY);
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public boolean transactionOuter() {
        return false;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String traceEntryMessageTemplate() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public abstract Integer traceEntryStackThresholdMillis();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public boolean traceEntryCaptureSelfNested() {
        return false;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String timerName() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String enabledProperty() {
        return "";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public String traceEntryEnabledProperty() {
        return "";
    }

    @JsonIgnore
    @Value.Derived
    public boolean isTimerOrGreater() {
        return this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TIMER || this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRACE_ENTRY || this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    @Value.Derived
    public boolean isTraceEntryOrGreater() {
        return this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRACE_ENTRY || this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    @Value.Derived
    public boolean isTransaction() {
        return this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    @Value.Derived
    public ImmutableList<String> validationErrors() {
        ArrayList<String> errors = Lists.newArrayList();
        if (this.className().isEmpty() && this.classAnnotation().isEmpty()) {
            errors.add("className and classAnnotation are both empty");
        }
        if (this.methodName().isEmpty() && this.methodAnnotation().isEmpty()) {
            errors.add("methodName and methodAnnotation are both empty");
        }
        if (this.isTimerOrGreater() && this.timerName().isEmpty()) {
            errors.add("timerName is empty");
        }
        if (this.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRACE_ENTRY && this.traceEntryMessageTemplate().isEmpty()) {
            errors.add("traceEntryMessageTemplate is empty");
        }
        if (this.isTransaction() && this.transactionType().isEmpty()) {
            errors.add("transactionType is empty");
        }
        if (this.isTransaction() && this.transactionNameTemplate().isEmpty()) {
            errors.add("transactionNameTemplate is empty");
        }
        if (!this.timerName().matches("[a-zA-Z0-9 ]*")) {
            errors.add("timerName contains invalid characters: " + this.timerName());
        }
        if (!this.methodDeclaringClassName().isEmpty()) {
            errors.add("methodDeclaringClassName is no longer supported");
        }
        return ImmutableList.copyOf(errors);
    }

    public void logValidationErrorsIfAny() {
        ImmutableList<String> errors = this.validationErrors();
        if (!errors.isEmpty()) {
            logger.error("invalid instrumentation config: {} - {}", (Object)Joiner.on(", ").join(errors), (Object)this);
        }
    }

    public AgentConfigOuterClass.AgentConfig.InstrumentationConfig toProto() {
        AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior;
        AgentConfigOuterClass.AgentConfig.InstrumentationConfig.Builder builder = AgentConfigOuterClass.AgentConfig.InstrumentationConfig.newBuilder().setClassName(this.className()).setClassAnnotation(this.classAnnotation()).setSubTypeRestriction(this.subTypeRestriction()).setSuperTypeRestriction(this.superTypeRestriction()).setMethodDeclaringClassName(this.methodDeclaringClassName()).setMethodName(this.methodName()).setMethodAnnotation(this.methodAnnotation()).addAllMethodParameterType(this.methodParameterTypes()).setMethodReturnType(this.methodReturnType()).addAllMethodModifier(this.methodModifiers()).setNestingGroup(this.nestingGroup()).setOrder(this.order()).setCaptureKind(this.captureKind()).setTransactionType(this.transactionType()).setTransactionNameTemplate(this.transactionNameTemplate()).setTransactionUserTemplate(this.transactionUserTemplate()).putAllTransactionAttributeTemplates(this.transactionAttributeTemplates());
        Integer transactionSlowThresholdMillis = this.transactionSlowThresholdMillis();
        if (transactionSlowThresholdMillis != null) {
            builder.setTransactionSlowThresholdMillis(Proto.OptionalInt32.newBuilder().setValue(transactionSlowThresholdMillis));
        }
        if ((alreadyInTransactionBehavior = this.alreadyInTransactionBehaviorCorrected()) != null) {
            builder.setAlreadyInTransactionBehavior(alreadyInTransactionBehavior);
        }
        builder.setTransactionOuter(this.transactionOuter()).setTraceEntryMessageTemplate(this.traceEntryMessageTemplate());
        Integer traceEntryStackThresholdMillis = this.traceEntryStackThresholdMillis();
        if (traceEntryStackThresholdMillis != null) {
            builder.setTraceEntryStackThresholdMillis(Proto.OptionalInt32.newBuilder().setValue(traceEntryStackThresholdMillis));
        }
        return builder.setTraceEntryCaptureSelfNested(this.traceEntryCaptureSelfNested()).setTimerName(this.timerName()).setEnabledProperty(this.enabledProperty()).setTraceEntryEnabledProperty(this.traceEntryEnabledProperty()).build();
    }

    public static ImmutableInstrumentationConfig create(AgentConfigOuterClass.AgentConfig.InstrumentationConfig config) {
        ImmutableInstrumentationConfig.Builder builder = ImmutableInstrumentationConfig.builder().className(config.getClassName()).classAnnotation(config.getClassAnnotation()).subTypeRestriction(config.getSubTypeRestriction()).superTypeRestriction(config.getSuperTypeRestriction()).methodDeclaringClassName(config.getMethodDeclaringClassName()).methodName(config.getMethodName()).methodAnnotation(config.getMethodAnnotation()).addAllMethodParameterTypes(config.getMethodParameterTypeList()).methodReturnType(config.getMethodReturnType()).addAllMethodModifiers(config.getMethodModifierList()).nestingGroup(config.getNestingGroup()).order(config.getOrder()).captureKind(config.getCaptureKind()).transactionType(config.getTransactionType()).transactionNameTemplate(config.getTransactionNameTemplate()).transactionUserTemplate(config.getTransactionUserTemplate()).putAllTransactionAttributeTemplates(config.getTransactionAttributeTemplatesMap());
        if (config.hasTransactionSlowThresholdMillis()) {
            builder.transactionSlowThresholdMillis(config.getTransactionSlowThresholdMillis().getValue());
        }
        if (config.getCaptureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION) {
            builder.alreadyInTransactionBehavior(config.getAlreadyInTransactionBehavior());
        }
        builder.transactionOuter(config.getTransactionOuter()).traceEntryMessageTemplate(config.getTraceEntryMessageTemplate());
        if (config.hasTraceEntryStackThresholdMillis()) {
            builder.traceEntryStackThresholdMillis(config.getTraceEntryStackThresholdMillis().getValue());
        }
        return builder.traceEntryCaptureSelfNested(config.getTraceEntryCaptureSelfNested()).timerName(config.getTimerName()).enabledProperty(config.getEnabledProperty()).traceEntryEnabledProperty(config.getTraceEntryEnabledProperty()).build();
    }
}

