/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSlowThresholdOverride;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TransactionConfig", generator="Immutables")
@Immutable
public final class ImmutableTransactionConfig
extends TransactionConfig {
    private final int slowThresholdMillis;
    private final int profilingIntervalMillis;
    private final boolean captureThreadStats;
    private final ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTransactionConfig(Builder builder) {
        this.slowThresholdOverrides = builder.slowThresholdOverrides.build();
        if (builder.slowThresholdMillisIsSet()) {
            this.initShim.slowThresholdMillis(builder.slowThresholdMillis);
        }
        if (builder.profilingIntervalMillisIsSet()) {
            this.initShim.profilingIntervalMillis(builder.profilingIntervalMillis);
        }
        if (builder.captureThreadStatsIsSet()) {
            this.initShim.captureThreadStats(builder.captureThreadStats);
        }
        this.slowThresholdMillis = this.initShim.slowThresholdMillis();
        this.profilingIntervalMillis = this.initShim.profilingIntervalMillis();
        this.captureThreadStats = this.initShim.captureThreadStats();
        this.initShim = null;
    }

    private ImmutableTransactionConfig(int slowThresholdMillis, int profilingIntervalMillis, boolean captureThreadStats, ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides) {
        this.slowThresholdMillis = slowThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.captureThreadStats = captureThreadStats;
        this.slowThresholdOverrides = slowThresholdOverrides;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="slowThresholdMillis")
    public int slowThresholdMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.slowThresholdMillis() : this.slowThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.profilingIntervalMillis() : this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="captureThreadStats")
    public boolean captureThreadStats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.captureThreadStats() : this.captureThreadStats;
    }

    @Override
    @JsonProperty(value="slowThresholdOverrides")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides() {
        return this.slowThresholdOverrides;
    }

    public final ImmutableTransactionConfig withSlowThresholdMillis(int value) {
        if (this.slowThresholdMillis == value) {
            return this;
        }
        return new ImmutableTransactionConfig(value, this.profilingIntervalMillis, this.captureThreadStats, this.slowThresholdOverrides);
    }

    public final ImmutableTransactionConfig withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        return new ImmutableTransactionConfig(this.slowThresholdMillis, value, this.captureThreadStats, this.slowThresholdOverrides);
    }

    public final ImmutableTransactionConfig withCaptureThreadStats(boolean value) {
        if (this.captureThreadStats == value) {
            return this;
        }
        return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, value, this.slowThresholdOverrides);
    }

    public final ImmutableTransactionConfig withSlowThresholdOverrides(ImmutableSlowThresholdOverride ... elements) {
        ImmutableList<ImmutableSlowThresholdOverride> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, newValue);
    }

    public final ImmutableTransactionConfig withSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
        if (this.slowThresholdOverrides == elements) {
            return this;
        }
        ImmutableList<ImmutableSlowThresholdOverride> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionConfig && this.equalTo((ImmutableTransactionConfig)another);
    }

    private boolean equalTo(ImmutableTransactionConfig another) {
        return this.slowThresholdMillis == another.slowThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.captureThreadStats == another.captureThreadStats && this.slowThresholdOverrides.equals(another.slowThresholdOverrides);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.slowThresholdMillis;
        h += (h << 5) + this.profilingIntervalMillis;
        h += (h << 5) + Booleans.hashCode(this.captureThreadStats);
        h += (h << 5) + this.slowThresholdOverrides.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionConfig").omitNullValues().add("slowThresholdMillis", this.slowThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("captureThreadStats", this.captureThreadStats).add("slowThresholdOverrides", this.slowThresholdOverrides).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionConfig fromJson(Json json) {
        Builder builder = ImmutableTransactionConfig.builder();
        if (json.slowThresholdMillisIsSet) {
            builder.slowThresholdMillis(json.slowThresholdMillis);
        }
        if (json.profilingIntervalMillisIsSet) {
            builder.profilingIntervalMillis(json.profilingIntervalMillis);
        }
        if (json.captureThreadStatsIsSet) {
            builder.captureThreadStats(json.captureThreadStats);
        }
        if (json.slowThresholdOverrides != null) {
            builder.addAllSlowThresholdOverrides(json.slowThresholdOverrides);
        }
        return builder.build();
    }

    public static ImmutableTransactionConfig copyOf(TransactionConfig instance) {
        if (instance instanceof ImmutableTransactionConfig) {
            return (ImmutableTransactionConfig)instance;
        }
        return ImmutableTransactionConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SLOW_THRESHOLD_MILLIS = 1L;
        private static final long OPT_BIT_PROFILING_INTERVAL_MILLIS = 2L;
        private static final long OPT_BIT_CAPTURE_THREAD_STATS = 4L;
        private long optBits;
        private int slowThresholdMillis;
        private int profilingIntervalMillis;
        private boolean captureThreadStats;
        private ImmutableList.Builder<ImmutableSlowThresholdOverride> slowThresholdOverrides = ImmutableList.builder();

        private Builder() {
        }

        public final Builder copyFrom(TransactionConfig instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.slowThresholdMillis(instance.slowThresholdMillis());
            this.profilingIntervalMillis(instance.profilingIntervalMillis());
            this.captureThreadStats(instance.captureThreadStats());
            this.addAllSlowThresholdOverrides(instance.slowThresholdOverrides());
            return this;
        }

        public final Builder slowThresholdMillis(int slowThresholdMillis) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.optBits |= 1L;
            return this;
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.optBits |= 2L;
            return this;
        }

        public final Builder captureThreadStats(boolean captureThreadStats) {
            this.captureThreadStats = captureThreadStats;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverride element) {
            this.slowThresholdOverrides.add((Object)element);
            return this;
        }

        public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverride ... elements) {
            this.slowThresholdOverrides.add(elements);
            return this;
        }

        public final Builder slowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
            this.slowThresholdOverrides = ImmutableList.builder();
            return this.addAllSlowThresholdOverrides(elements);
        }

        public final Builder addAllSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
            this.slowThresholdOverrides.addAll(elements);
            return this;
        }

        public ImmutableTransactionConfig build() {
            return new ImmutableTransactionConfig(this);
        }

        private boolean slowThresholdMillisIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean captureThreadStatsIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionConfig", generator="Immutables")
    static final class Json
    extends TransactionConfig {
        int slowThresholdMillis;
        boolean slowThresholdMillisIsSet;
        int profilingIntervalMillis;
        boolean profilingIntervalMillisIsSet;
        boolean captureThreadStats;
        boolean captureThreadStatsIsSet;
        @Nullable
        ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="slowThresholdMillis")
        public void setSlowThresholdMillis(int slowThresholdMillis) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.slowThresholdMillisIsSet = true;
        }

        @JsonProperty(value="profilingIntervalMillis")
        public void setProfilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.profilingIntervalMillisIsSet = true;
        }

        @JsonProperty(value="captureThreadStats")
        public void setCaptureThreadStats(boolean captureThreadStats) {
            this.captureThreadStats = captureThreadStats;
            this.captureThreadStatsIsSet = true;
        }

        @JsonProperty(value="slowThresholdOverrides")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setSlowThresholdOverrides(ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides) {
            this.slowThresholdOverrides = slowThresholdOverrides;
        }

        @Override
        public int slowThresholdMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int profilingIntervalMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean captureThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="TransactionConfig", generator="Immutables")
    private final class InitShim {
        private byte slowThresholdMillisBuildStage = 0;
        private int slowThresholdMillis;
        private byte profilingIntervalMillisBuildStage = 0;
        private int profilingIntervalMillis;
        private byte captureThreadStatsBuildStage = 0;
        private boolean captureThreadStats;

        private InitShim() {
        }

        int slowThresholdMillis() {
            if (this.slowThresholdMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.slowThresholdMillisBuildStage == 0) {
                this.slowThresholdMillisBuildStage = (byte)-1;
                this.slowThresholdMillis = ImmutableTransactionConfig.super.slowThresholdMillis();
                this.slowThresholdMillisBuildStage = 1;
            }
            return this.slowThresholdMillis;
        }

        void slowThresholdMillis(int slowThresholdMillis) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.slowThresholdMillisBuildStage = 1;
        }

        int profilingIntervalMillis() {
            if (this.profilingIntervalMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.profilingIntervalMillisBuildStage == 0) {
                this.profilingIntervalMillisBuildStage = (byte)-1;
                this.profilingIntervalMillis = ImmutableTransactionConfig.super.profilingIntervalMillis();
                this.profilingIntervalMillisBuildStage = 1;
            }
            return this.profilingIntervalMillis;
        }

        void profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.profilingIntervalMillisBuildStage = 1;
        }

        boolean captureThreadStats() {
            if (this.captureThreadStatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.captureThreadStatsBuildStage == 0) {
                this.captureThreadStatsBuildStage = (byte)-1;
                this.captureThreadStats = ImmutableTransactionConfig.super.captureThreadStats();
                this.captureThreadStatsBuildStage = 1;
            }
            return this.captureThreadStats;
        }

        void captureThreadStats(boolean captureThreadStats) {
            this.captureThreadStats = captureThreadStats;
            this.captureThreadStatsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.slowThresholdMillisBuildStage == -1) {
                attributes.add("slowThresholdMillis");
            }
            if (this.profilingIntervalMillisBuildStage == -1) {
                attributes.add("profilingIntervalMillis");
            }
            if (this.captureThreadStatsBuildStage == -1) {
                attributes.add("captureThreadStats");
            }
            return "Cannot build TransactionConfig, attribute initializers form cycle " + attributes;
        }
    }
}

