/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="JvmConfig", generator="Immutables")
@Immutable
public final class ImmutableJvmConfig
extends JvmConfig {
    private final ImmutableList<String> maskSystemProperties;
    private final ImmutableList<String> maskMBeanAttributes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJvmConfig(Builder builder) {
        if (builder.maskSystemPropertiesIsSet()) {
            this.initShim.maskSystemProperties((ImmutableList<String>)builder.maskSystemProperties.build());
        }
        if (builder.maskMBeanAttributesIsSet()) {
            this.initShim.maskMBeanAttributes((ImmutableList<String>)builder.maskMBeanAttributes.build());
        }
        this.maskSystemProperties = this.initShim.maskSystemProperties();
        this.maskMBeanAttributes = this.initShim.maskMBeanAttributes();
        this.initShim = null;
    }

    private ImmutableJvmConfig(ImmutableList<String> maskSystemProperties, ImmutableList<String> maskMBeanAttributes) {
        this.maskSystemProperties = maskSystemProperties;
        this.maskMBeanAttributes = maskMBeanAttributes;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="maskSystemProperties")
    public ImmutableList<String> maskSystemProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maskSystemProperties() : this.maskSystemProperties;
    }

    @Override
    @JsonProperty(value="maskMBeanAttributes")
    public ImmutableList<String> maskMBeanAttributes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maskMBeanAttributes() : this.maskMBeanAttributes;
    }

    public final ImmutableJvmConfig withMaskSystemProperties(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfig(newValue, this.maskMBeanAttributes);
    }

    public final ImmutableJvmConfig withMaskSystemProperties(Iterable<String> elements) {
        if (this.maskSystemProperties == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfig(newValue, this.maskMBeanAttributes);
    }

    public final ImmutableJvmConfig withMaskMBeanAttributes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfig(this.maskSystemProperties, newValue);
    }

    public final ImmutableJvmConfig withMaskMBeanAttributes(Iterable<String> elements) {
        if (this.maskMBeanAttributes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfig(this.maskSystemProperties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJvmConfig && this.equalTo((ImmutableJvmConfig)another);
    }

    private boolean equalTo(ImmutableJvmConfig another) {
        return this.maskSystemProperties.equals(another.maskSystemProperties) && this.maskMBeanAttributes.equals(another.maskMBeanAttributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maskSystemProperties.hashCode();
        h += (h << 5) + this.maskMBeanAttributes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JvmConfig").omitNullValues().add("maskSystemProperties", this.maskSystemProperties).add("maskMBeanAttributes", this.maskMBeanAttributes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJvmConfig fromJson(Json json) {
        Builder builder = ImmutableJvmConfig.builder();
        if (json.maskSystemPropertiesIsSet) {
            builder.addAllMaskSystemProperties(json.maskSystemProperties);
        }
        if (json.maskMBeanAttributesIsSet) {
            builder.addAllMaskMBeanAttributes(json.maskMBeanAttributes);
        }
        return builder.build();
    }

    public static ImmutableJvmConfig copyOf(JvmConfig instance) {
        if (instance instanceof ImmutableJvmConfig) {
            return (ImmutableJvmConfig)instance;
        }
        return ImmutableJvmConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JvmConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MASK_SYSTEM_PROPERTIES = 1L;
        private static final long OPT_BIT_MASK_M_BEAN_ATTRIBUTES = 2L;
        private long optBits;
        private ImmutableList.Builder<String> maskSystemProperties = ImmutableList.builder();
        private ImmutableList.Builder<String> maskMBeanAttributes = ImmutableList.builder();

        private Builder() {
        }

        public final Builder copyFrom(JvmConfig instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.addAllMaskSystemProperties(instance.maskSystemProperties());
            this.addAllMaskMBeanAttributes(instance.maskMBeanAttributes());
            return this;
        }

        public final Builder addMaskSystemProperties(String element) {
            this.maskSystemProperties.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMaskSystemProperties(String ... elements) {
            this.maskSystemProperties.add(elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder maskSystemProperties(Iterable<String> elements) {
            this.maskSystemProperties = ImmutableList.builder();
            return this.addAllMaskSystemProperties(elements);
        }

        public final Builder addAllMaskSystemProperties(Iterable<String> elements) {
            this.maskSystemProperties.addAll((Iterable)elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMaskMBeanAttributes(String element) {
            this.maskMBeanAttributes.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        public final Builder addMaskMBeanAttributes(String ... elements) {
            this.maskMBeanAttributes.add(elements);
            this.optBits |= 2L;
            return this;
        }

        public final Builder maskMBeanAttributes(Iterable<String> elements) {
            this.maskMBeanAttributes = ImmutableList.builder();
            return this.addAllMaskMBeanAttributes(elements);
        }

        public final Builder addAllMaskMBeanAttributes(Iterable<String> elements) {
            this.maskMBeanAttributes.addAll((Iterable)elements);
            this.optBits |= 2L;
            return this;
        }

        public ImmutableJvmConfig build() {
            return new ImmutableJvmConfig(this);
        }

        private boolean maskSystemPropertiesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean maskMBeanAttributesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JvmConfig", generator="Immutables")
    static final class Json
    extends JvmConfig {
        @Nullable
        ImmutableList<String> maskSystemProperties = ImmutableList.of();
        boolean maskSystemPropertiesIsSet;
        @Nullable
        ImmutableList<String> maskMBeanAttributes = ImmutableList.of();
        boolean maskMBeanAttributesIsSet;

        Json() {
        }

        @JsonProperty(value="maskSystemProperties")
        public void setMaskSystemProperties(ImmutableList<String> maskSystemProperties) {
            this.maskSystemProperties = maskSystemProperties;
            this.maskSystemPropertiesIsSet = true;
        }

        @JsonProperty(value="maskMBeanAttributes")
        public void setMaskMBeanAttributes(ImmutableList<String> maskMBeanAttributes) {
            this.maskMBeanAttributes = maskMBeanAttributes;
            this.maskMBeanAttributesIsSet = true;
        }

        @Override
        public ImmutableList<String> maskSystemProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> maskMBeanAttributes() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="JvmConfig", generator="Immutables")
    private final class InitShim {
        private byte maskSystemPropertiesBuildStage = 0;
        private ImmutableList<String> maskSystemProperties;
        private byte maskMBeanAttributesBuildStage = 0;
        private ImmutableList<String> maskMBeanAttributes;

        private InitShim() {
        }

        ImmutableList<String> maskSystemProperties() {
            if (this.maskSystemPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maskSystemPropertiesBuildStage == 0) {
                this.maskSystemPropertiesBuildStage = (byte)-1;
                this.maskSystemProperties = Preconditions.checkNotNull(ImmutableJvmConfig.super.maskSystemProperties(), "maskSystemProperties");
                this.maskSystemPropertiesBuildStage = 1;
            }
            return this.maskSystemProperties;
        }

        void maskSystemProperties(ImmutableList<String> maskSystemProperties) {
            this.maskSystemProperties = maskSystemProperties;
            this.maskSystemPropertiesBuildStage = 1;
        }

        ImmutableList<String> maskMBeanAttributes() {
            if (this.maskMBeanAttributesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maskMBeanAttributesBuildStage == 0) {
                this.maskMBeanAttributesBuildStage = (byte)-1;
                this.maskMBeanAttributes = Preconditions.checkNotNull(ImmutableJvmConfig.super.maskMBeanAttributes(), "maskMBeanAttributes");
                this.maskMBeanAttributesBuildStage = 1;
            }
            return this.maskMBeanAttributes;
        }

        void maskMBeanAttributes(ImmutableList<String> maskMBeanAttributes) {
            this.maskMBeanAttributes = maskMBeanAttributes;
            this.maskMBeanAttributesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.maskSystemPropertiesBuildStage == -1) {
                attributes.add("maskSystemProperties");
            }
            if (this.maskMBeanAttributesBuildStage == -1) {
                attributes.add("maskMBeanAttributes");
            }
            return "Cannot build JvmConfig, attribute initializers form cycle " + attributes;
        }
    }
}

