/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableEmailNotification;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableHeartbeatCondition;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableMetricCondition;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutablePagerDutyNotification;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSlackNotification;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSyntheticMonitorCondition;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AlertConfig {
    public abstract AlertCondition condition();

    public abstract AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity();

    @Nullable
    public abstract ImmutableEmailNotification emailNotification();

    @Nullable
    public abstract ImmutablePagerDutyNotification pagerDutyNotification();

    @Nullable
    public abstract ImmutableSlackNotification slackNotification();

    public static ImmutableAlertConfig create(AgentConfigOuterClass.AgentConfig.AlertConfig config) {
        ImmutableAlertConfig.Builder builder = ImmutableAlertConfig.builder().condition(AlertConfig.create(config.getCondition())).severity(config.getSeverity());
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification notification = config.getNotification();
        if (notification.hasEmailNotification()) {
            builder.emailNotification(AlertConfig.create(notification.getEmailNotification()));
        }
        if (notification.hasPagerDutyNotification()) {
            builder.pagerDutyNotification(AlertConfig.create(notification.getPagerDutyNotification()));
        }
        if (notification.hasSlackNotification()) {
            builder.slackNotification(AlertConfig.create(notification.getSlackNotification()));
        }
        return builder.build();
    }

    public AgentConfigOuterClass.AgentConfig.AlertConfig toProto() {
        ImmutableSlackNotification slackNotification;
        ImmutablePagerDutyNotification pagerDutyNotification;
        AgentConfigOuterClass.AgentConfig.AlertConfig.Builder builder = AgentConfigOuterClass.AgentConfig.AlertConfig.newBuilder().setCondition(AlertConfig.toProto(this.condition())).setSeverity(this.severity());
        ImmutableEmailNotification emailNotification = this.emailNotification();
        if (emailNotification != null) {
            builder.getNotificationBuilder().setEmailNotification(AlertConfig.toProto(emailNotification));
        }
        if ((pagerDutyNotification = this.pagerDutyNotification()) != null) {
            builder.getNotificationBuilder().setPagerDutyNotification(AlertConfig.toProto(pagerDutyNotification));
        }
        if ((slackNotification = this.slackNotification()) != null) {
            builder.getNotificationBuilder().setSlackNotification(AlertConfig.toProto(slackNotification));
        }
        return builder.build();
    }

    private static AlertCondition create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition) {
        switch (alertCondition.getValCase()) {
            case METRIC_CONDITION: {
                return AlertConfig.create(alertCondition.getMetricCondition());
            }
            case SYNTHETIC_MONITOR_CONDITION: {
                return AlertConfig.create(alertCondition.getSyntheticMonitorCondition());
            }
            case HEARTBEAT_CONDITION: {
                return AlertConfig.create(alertCondition.getHeartbeatCondition());
            }
        }
        throw new IllegalStateException("Unexpected condition kind: " + alertCondition.getValCase().name());
    }

    private static ImmutableEmailNotification create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification emailNotification) {
        return ImmutableEmailNotification.builder().addAllEmailAddresses(emailNotification.getEmailAddressList()).build();
    }

    private static ImmutablePagerDutyNotification create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification) {
        return ImmutablePagerDutyNotification.builder().pagerDutyIntegrationKey(pagerDutyNotification.getPagerDutyIntegrationKey()).build();
    }

    private static ImmutableSlackNotification create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification slackNotification) {
        return ImmutableSlackNotification.builder().slackWebhookId(slackNotification.getSlackWebhookId()).addAllSlackChannels(slackNotification.getSlackChannelList()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition toProto(AlertCondition condition) {
        if (condition instanceof MetricCondition) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setMetricCondition(AlertConfig.toProto((MetricCondition)condition)).build();
        }
        if (condition instanceof SyntheticMonitorCondition) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setSyntheticMonitorCondition(AlertConfig.toProto((SyntheticMonitorCondition)condition)).build();
        }
        if (condition instanceof HeartbeatCondition) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setHeartbeatCondition(AlertConfig.toProto((HeartbeatCondition)condition)).build();
        }
        throw new IllegalStateException("Unexpected alert condition type: " + condition.getClass().getName());
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification toProto(EmailNotification emailNotification) {
        return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification.newBuilder().addAllEmailAddress(emailNotification.emailAddresses()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification toProto(PagerDutyNotification pagerDutyNotification) {
        return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification.newBuilder().setPagerDutyIntegrationKey(pagerDutyNotification.pagerDutyIntegrationKey()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification toProto(SlackNotification slackNotification) {
        return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification.newBuilder().setSlackWebhookId(slackNotification.slackWebhookId()).addAllSlackChannel(slackNotification.slackChannels()).build();
    }

    private static MetricCondition create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition condition) {
        ImmutableMetricCondition.Builder builder = ImmutableMetricCondition.builder().metric(condition.getMetric());
        builder.transactionType(Strings.emptyToNull(condition.getTransactionType()));
        builder.transactionName(Strings.emptyToNull(condition.getTransactionName()));
        if (condition.hasPercentile()) {
            builder.percentile(condition.getPercentile().getValue());
        }
        builder.errorMessageFilter(Strings.emptyToNull(condition.getErrorMessageFilter()));
        return builder.threshold(condition.getThreshold()).lowerBoundThreshold(condition.getLowerBoundThreshold()).timePeriodSeconds(condition.getTimePeriodSeconds()).minTransactionCount(condition.getMinTransactionCount()).build();
    }

    private static SyntheticMonitorCondition create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition condition) {
        ImmutableSyntheticMonitorCondition.Builder builder = ImmutableSyntheticMonitorCondition.builder().syntheticMonitorId(condition.getSyntheticMonitorId()).thresholdMillis(condition.getThresholdMillis());
        int consecutiveCount = condition.getConsecutiveCount();
        if (consecutiveCount == 0) {
            builder.consecutiveCount(1);
        } else {
            builder.consecutiveCount(consecutiveCount);
        }
        return builder.build();
    }

    private static HeartbeatCondition create(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition condition) {
        return ImmutableHeartbeatCondition.builder().timePeriodSeconds(condition.getTimePeriodSeconds()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition toProto(MetricCondition condition) {
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition.Builder builder = AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition.newBuilder().setMetric(condition.metric());
        builder.setTransactionType(Strings.nullToEmpty(condition.transactionType())).setTransactionName(Strings.nullToEmpty(condition.transactionName()));
        Double percentile = condition.percentile();
        if (percentile != null) {
            builder.setPercentile(Proto.OptionalDouble.newBuilder().setValue(percentile));
        }
        return builder.setErrorMessageFilter(Strings.nullToEmpty(condition.errorMessageFilter())).setThreshold(condition.threshold()).setLowerBoundThreshold(condition.lowerBoundThreshold()).setTimePeriodSeconds(condition.timePeriodSeconds()).setMinTransactionCount(condition.minTransactionCount()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition toProto(SyntheticMonitorCondition condition) {
        return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition.newBuilder().setSyntheticMonitorId(condition.syntheticMonitorId()).setThresholdMillis(condition.thresholdMillis()).setConsecutiveCount(condition.consecutiveCount()).build();
    }

    private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition toProto(HeartbeatCondition condition) {
        return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition.newBuilder().setTimePeriodSeconds(condition.timePeriodSeconds()).build();
    }

    @Value.Immutable
    static interface SlackNotification {
        public String slackWebhookId();

        public List<String> slackChannels();
    }

    @Value.Immutable
    static interface PagerDutyNotification {
        public String pagerDutyIntegrationKey();
    }

    @Value.Immutable
    static interface EmailNotification {
        public List<String> emailAddresses();
    }

    @Value.Immutable
    static interface HeartbeatCondition
    extends AlertCondition {
        public int timePeriodSeconds();
    }

    @Value.Immutable
    static interface SyntheticMonitorCondition
    extends AlertCondition {
        public String syntheticMonitorId();

        public int thresholdMillis();

        public int consecutiveCount();
    }

    @Value.Immutable
    static abstract class MetricCondition
    implements AlertCondition {
        MetricCondition() {
        }

        abstract String metric();

        @Nullable
        abstract String transactionType();

        @Nullable
        abstract String transactionName();

        @Nullable
        abstract Double percentile();

        @Nullable
        abstract String errorMessageFilter();

        abstract double threshold();

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Value.Default
        boolean lowerBoundThreshold() {
            return false;
        }

        abstract int timePeriodSeconds();

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Value.Default
        long minTransactionCount() {
            return 0L;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="conditionType")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableMetricCondition.class, name="metric"), @JsonSubTypes.Type(value=ImmutableSyntheticMonitorCondition.class, name="synthetic-monitor"), @JsonSubTypes.Type(value=ImmutableHeartbeatCondition.class, name="heartbeat")})
    static interface AlertCondition {
    }
}

