/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.trace;

import org.glowroot.agent.shaded.io.opencensus.trace.Tracer;
import org.glowroot.agent.shaded.io.opencensus.trace.export.ExportComponent;
import org.glowroot.agent.shaded.io.opencensus.trace.propagation.PropagationComponent;

public abstract class TraceComponent {
    public abstract Tracer getTracer();

    public abstract PropagationComponent getPropagationComponent();

    static TraceComponent newNoopTraceComponent() {
        return new NoopTraceComponent();
    }

    private static final class NoopTraceComponent
    extends TraceComponent {
        private final ExportComponent noopExportComponent = ExportComponent.newNoopExportComponent();

        @Override
        public Tracer getTracer() {
            return Tracer.getNoopTracer();
        }

        @Override
        public PropagationComponent getPropagationComponent() {
            return PropagationComponent.getNoopPropagationComponent();
        }

        private NoopTraceComponent() {
        }
    }
}

