/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.trace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.opencensus.internal.BaseMessageEventUtil;
import org.glowroot.agent.shaded.io.opencensus.trace.EndSpanOptions;
import org.glowroot.agent.shaded.io.opencensus.trace.MessageEvent;
import org.glowroot.agent.shaded.io.opencensus.trace.NetworkEvent;
import org.glowroot.agent.shaded.io.opencensus.trace.SpanContext;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public abstract class Span {
    private static final Map<String, Object> EMPTY_ATTRIBUTES = Collections.emptyMap();
    private final SpanContext context;
    private final Set<Options> options;
    private static final Set<Options> DEFAULT_OPTIONS = Collections.unmodifiableSet(EnumSet.noneOf(Options.class));

    protected Span(SpanContext context, @Nullable EnumSet<Options> options) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.options = options == null ? DEFAULT_OPTIONS : Collections.unmodifiableSet(EnumSet.copyOf(options));
        Preconditions.checkArgument(!context.getTraceOptions().isSampled() || this.options.contains((Object)Options.RECORD_EVENTS), "Span is sampled, but does not have RECORD_EVENTS set.");
    }

    @Deprecated
    public void addNetworkEvent(NetworkEvent networkEvent) {
        this.addMessageEvent(BaseMessageEventUtil.asMessageEvent(networkEvent));
    }

    public void addMessageEvent(MessageEvent messageEvent) {
        this.addNetworkEvent(BaseMessageEventUtil.asNetworkEvent(messageEvent));
    }

    public abstract void end(EndSpanOptions var1);

    public final SpanContext getContext() {
        return this.context;
    }

    public static enum Options {
        RECORD_EVENTS;

    }
}

