/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.stats;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.opencensus.internal.StringUtil;
import org.glowroot.agent.shaded.io.opencensus.stats.AutoValue_Measure_MeasureDouble;
import org.glowroot.agent.shaded.io.opencensus.stats.AutoValue_Measure_MeasureLong;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Measure {
    private Measure() {
    }

    @Immutable
    public static abstract class MeasureLong
    extends Measure {
        MeasureLong() {
        }

        public static MeasureLong create(String name, String description, String unit) {
            Preconditions.checkArgument(StringUtil.isPrintableString(name) && name.length() <= 255, "Name should be a ASCII string with a length no greater than 255 characters.");
            return new AutoValue_Measure_MeasureLong(name, description, unit);
        }

        public abstract String getName();

        public abstract String getDescription();

        public abstract String getUnit();
    }

    @Immutable
    public static abstract class MeasureDouble
    extends Measure {
        MeasureDouble() {
        }

        public static MeasureDouble create(String name, String description, String unit) {
            Preconditions.checkArgument(StringUtil.isPrintableString(name) && name.length() <= 255, "Name should be a ASCII string with a length no greater than 255 characters.");
            return new AutoValue_Measure_MeasureDouble(name, description, unit);
        }

        public abstract String getName();

        public abstract String getDescription();

        public abstract String getUnit();
    }
}

