/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.resolver;

import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import org.glowroot.agent.shaded.io.netty.resolver.AddressResolver;
import org.glowroot.agent.shaded.io.netty.util.concurrent.EventExecutor;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Future;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Promise;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;
import org.glowroot.agent.shaded.io.netty.util.internal.TypeParameterMatcher;

public abstract class AbstractAddressResolver<T extends SocketAddress>
implements AddressResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    protected AbstractAddressResolver(EventExecutor executor) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.matcher = TypeParameterMatcher.find(this, AbstractAddressResolver.class, "T");
    }

    protected AbstractAddressResolver(EventExecutor executor, Class<? extends T> addressType) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.matcher = TypeParameterMatcher.get(addressType);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isSupported(SocketAddress address) {
        return this.matcher.match(address);
    }

    @Override
    public final boolean isResolved(SocketAddress address) {
        if (!this.isSupported(address)) {
            throw new UnsupportedAddressTypeException();
        }
        SocketAddress castAddress = address;
        return this.doIsResolved(castAddress);
    }

    protected abstract boolean doIsResolved(T var1);

    @Override
    public final Future<T> resolve(SocketAddress address) {
        if (!this.isSupported(ObjectUtil.checkNotNull(address, "address"))) {
            return this.executor().newFailedFuture(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast = address;
            return this.executor.newSucceededFuture(cast);
        }
        try {
            SocketAddress cast = address;
            Promise promise = this.executor().newPromise();
            this.doResolve(cast, promise);
            return promise;
        }
        catch (Exception e) {
            return this.executor().newFailedFuture(e);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2) throws Exception;

    @Override
    public void close() {
    }
}

