/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.ssl;

import java.util.LinkedHashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.glowroot.agent.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import org.glowroot.agent.shaded.io.netty.handler.ssl.JdkSslEngine;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;
import org.glowroot.agent.shaded.org.eclipse.jetty.npn.NextProtoNego;

final class JettyNpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JettyNpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.NextProtoNegoExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JettyNpnSslEngine(SSLEngine engine, final JdkApplicationProtocolNegotiator applicationNegotiator, boolean server) {
        super(engine);
        ObjectUtil.checkNotNull(applicationNegotiator, "applicationNegotiator");
        if (server) {
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = ObjectUtil.checkNotNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
            NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){});
        } else {
            final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = ObjectUtil.checkNotNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
            NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new NextProtoNego.ClientProvider(){});
        }
    }

    @Override
    public void closeInbound() throws SSLException {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

