/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http2;

import java.util.Iterator;
import java.util.Map;
import org.glowroot.agent.shaded.io.netty.handler.codec.Headers;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.CharSequenceMap;
import org.glowroot.agent.shaded.io.netty.util.AsciiString;

public interface Http2Headers
extends Headers<CharSequence, CharSequence, Http2Headers> {
    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    public CharSequence status();

    public static enum PseudoHeaderName {
        METHOD(":method", true),
        SCHEME(":scheme", true),
        AUTHORITY(":authority", true),
        PATH(":path", true),
        STATUS(":status", false);

        private final AsciiString value;
        private final boolean requestOnly;
        private static final CharSequenceMap<PseudoHeaderName> PSEUDO_HEADERS;

        private PseudoHeaderName(String value, boolean requestOnly) {
            this.value = AsciiString.cached(value);
            this.requestOnly = requestOnly;
        }

        public AsciiString value() {
            return this.value;
        }

        public static boolean hasPseudoHeaderFormat(CharSequence headerName) {
            if (headerName instanceof AsciiString) {
                AsciiString asciiHeaderName = (AsciiString)headerName;
                return asciiHeaderName.length() > 0 && asciiHeaderName.byteAt(0) == 58;
            }
            return headerName.length() > 0 && headerName.charAt(0) == ':';
        }

        public static PseudoHeaderName getPseudoHeader(CharSequence header) {
            return (PseudoHeaderName)((Object)PSEUDO_HEADERS.get(header));
        }

        public boolean isRequestOnly() {
            return this.requestOnly;
        }

        static {
            PSEUDO_HEADERS = new CharSequenceMap();
            for (PseudoHeaderName pseudoHeader : PseudoHeaderName.values()) {
                PSEUDO_HEADERS.add(pseudoHeader.value(), pseudoHeader);
            }
        }
    }
}

