/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.stub;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor;
import org.glowroot.agent.shaded.io.grpc.ServerCallHandler;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.stub.StreamObserver;

public final class ServerCalls {
    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryCall(UnaryMethod<ReqT, RespT> method) {
        return ServerCalls.asyncUnaryRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncClientStreamingCall(ClientStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncBidiStreamingCall(BidiStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryRequestCall(UnaryRequestMethod<ReqT, RespT> method) {
        return new UnaryServerCallHandler<ReqT, RespT>(method);
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncStreamingRequestCall(StreamingRequestMethod<ReqT, RespT> method) {
        return new StreamingServerCallHandler<ReqT, RespT>(method);
    }

    public static void asyncUnimplementedUnaryCall(MethodDescriptor<?, ?> methodDescriptor, StreamObserver<?> responseObserver) {
        Preconditions.checkNotNull(methodDescriptor, "methodDescriptor");
        Preconditions.checkNotNull(responseObserver, "responseObserver");
        responseObserver.onError(Status.UNIMPLEMENTED.withDescription(String.format("Method %s is unimplemented", methodDescriptor.getFullMethodName())).asRuntimeException());
    }

    public static <T> StreamObserver<T> asyncUnimplementedStreamingCall(MethodDescriptor<?, ?> methodDescriptor, StreamObserver<?> responseObserver) {
        ServerCalls.asyncUnimplementedUnaryCall(methodDescriptor, responseObserver);
        return new NoopStreamObserver();
    }

    static class NoopStreamObserver<V>
    implements StreamObserver<V> {
        NoopStreamObserver() {
        }

        @Override
        public void onNext(V value) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onCompleted() {
        }
    }

    private static interface StreamingRequestMethod<ReqT, RespT> {
    }

    private static interface UnaryRequestMethod<ReqT, RespT> {
    }

    private static final class StreamingServerCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final StreamingRequestMethod<ReqT, RespT> method;

        StreamingServerCallHandler(StreamingRequestMethod<ReqT, RespT> method) {
            this.method = method;
        }
    }

    private static final class UnaryServerCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final UnaryRequestMethod<ReqT, RespT> method;

        UnaryServerCallHandler(UnaryRequestMethod<ReqT, RespT> method) {
            this.method = method;
        }
    }

    public static interface BidiStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface ClientStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface UnaryMethod<ReqT, RespT>
    extends UnaryRequestMethod<ReqT, RespT> {
    }
}

