/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.Channelz;
import org.glowroot.agent.shaded.io.grpc.internal.KeepAliveManager;
import org.glowroot.agent.shaded.io.grpc.internal.LogExceptionRunnable;
import org.glowroot.agent.shaded.io.grpc.internal.TransportTracer;
import org.glowroot.agent.shaded.io.grpc.netty.AbstractNettyHandler;
import org.glowroot.agent.shaded.io.grpc.netty.CancelServerStreamCommand;
import org.glowroot.agent.shaded.io.grpc.netty.ForcefulCloseCommand;
import org.glowroot.agent.shaded.io.grpc.netty.MaxConnectionIdleManager;
import org.glowroot.agent.shaded.io.grpc.netty.NettyServerStream;
import org.glowroot.agent.shaded.io.grpc.netty.SendGrpcFrameCommand;
import org.glowroot.agent.shaded.io.grpc.netty.SendResponseHeadersCommand;
import org.glowroot.agent.shaded.io.grpc.netty.Utils;
import org.glowroot.agent.shaded.io.grpc.netty.WriteQueue;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBufUtil;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFuture;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFutureListener;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.channel.ChannelPromise;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Error;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2FlowController;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Stream;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2StreamVisitor;
import org.glowroot.agent.shaded.io.netty.util.ReferenceCountUtil;
import org.glowroot.agent.shaded.javax.annotation.CheckForNull;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

class NettyServerHandler
extends AbstractNettyHandler {
    private static final Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private static final long GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final Http2Connection.PropertyKey streamKey;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final TransportTracer transportTracer;
    private Attributes negotiationAttributes;
    private Channelz.Security securityInfo;
    private Throwable connectionError;
    private WriteQueue serverWriteQueue;
    @CheckForNull
    private KeepAliveManager keepAliveManager;
    @CheckForNull
    private MaxConnectionIdleManager maxConnectionIdleManager;
    @CheckForNull
    private ScheduledFuture<?> maxConnectionAgeMonitor;
    @CheckForNull
    private GracefulShutdown gracefulShutdown;

    @Override
    public void handlerAdded(final ChannelHandlerContext ctx) throws Exception {
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        if (this.maxConnectionAgeInNanos != Long.MAX_VALUE) {
            this.maxConnectionAgeMonitor = ctx.executor().schedule(new LogExceptionRunnable(new Runnable(){

                @Override
                public void run() {
                    if (NettyServerHandler.this.gracefulShutdown == null) {
                        NettyServerHandler.this.gracefulShutdown = new GracefulShutdown("max_age", NettyServerHandler.this.maxConnectionAgeGraceInNanos);
                        NettyServerHandler.this.gracefulShutdown.start(ctx);
                        ctx.flush();
                    }
                }
            }), this.maxConnectionAgeInNanos, TimeUnit.NANOSECONDS);
        }
        if (this.maxConnectionIdleManager != null) {
            this.maxConnectionIdleManager.start(ctx);
        }
        if (this.keepAliveTimeInNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAlivePinger(ctx), ctx.executor(), this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, true);
            this.keepAliveManager.onTransportStarted();
        }
        if (this.transportTracer != null) {
            assert (this.encoder().connection().equals(this.decoder().connection()));
            final Http2Connection connection = this.encoder().connection();
            this.transportTracer.setFlowControlWindowReader(new TransportTracer.FlowControlReader(){
                private final Http2FlowController local;
                private final Http2FlowController remote;
                {
                    this.local = connection.local().flowController();
                    this.remote = connection.remote().flowController();
                }
            });
        }
        super.handlerAdded(ctx);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.FINE, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, outbound, cause, http2Ex);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.log(Level.WARNING, "Stream Error", cause);
        NettyServerStream.TransportState serverStream = this.serverStream(this.connection().stream(Http2Exception.streamId(http2Ex)));
        if (serverStream != null) {
            serverStream.transportReportStatus(Utils.statusFromThrowable(cause));
        }
        super.onStreamError(ctx, outbound, cause, http2Ex);
    }

    @Override
    public void handleProtocolNegotiationCompleted(Attributes attrs, Channelz.Security securityInfo) {
        this.negotiationAttributes = attrs;
        this.securityInfo = securityInfo;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportTermination();
            }
            if (this.maxConnectionIdleManager != null) {
                this.maxConnectionIdleManager.onTransportTermination();
            }
            if (this.maxConnectionAgeMonitor != null) {
                this.maxConnectionAgeMonitor.cancel(false);
            }
            final Status status = Status.UNAVAILABLE.withDescription("connection terminated for unknown reason");
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                    if (serverStream != null) {
                        serverStream.transportReportStatus(status);
                    }
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)msg, promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof CancelServerStreamCommand) {
            this.cancelStream(ctx, (CancelServerStreamCommand)msg, promise);
        } else if (msg instanceof ForcefulCloseCommand) {
            this.forcefulClose(ctx, (ForcefulCloseCommand)msg, promise);
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release(msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream.TransportState stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        int streamId = cmd.stream().id();
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            this.resetStream(ctx, streamId, Http2Error.CANCEL.code(), promise);
            return;
        }
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, streamId);
        }
        this.encoder().writeHeaders(ctx, streamId, cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelServerStreamCommand cmd, ChannelPromise promise) {
        cmd.stream().transportReportStatus(cmd.reason());
        this.encoder().writeRstStream(ctx, cmd.stream().id(), Http2Error.CANCEL.code(), promise);
    }

    private void forcefulClose(final ChannelHandlerContext ctx, final ForcefulCloseCommand msg, ChannelPromise promise) throws Exception {
        this.close(ctx, promise);
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            @Override
            public boolean visit(Http2Stream stream) throws Http2Exception {
                NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                if (serverStream != null) {
                    serverStream.transportReportStatus(msg.getStatus());
                    NettyServerHandler.this.resetStream(ctx, stream.id(), Http2Error.CANCEL.code(), ctx.newPromise());
                }
                stream.close();
                return true;
            }
        });
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private NettyServerStream.TransportState serverStream(Http2Stream stream) {
        return stream == null ? null : (NettyServerStream.TransportState)stream.getProperty(this.streamKey);
    }

    private final class GracefulShutdown {
        String goAwayMessage;
        @CheckForNull
        Long graceTimeInNanos;
        boolean pingAckedOrTimeout;
        Future<?> pingFuture;

        GracefulShutdown(@Nullable String goAwayMessage, Long graceTimeInNanos) {
            this.goAwayMessage = goAwayMessage;
            this.graceTimeInNanos = graceTimeInNanos;
        }

        void start(final ChannelHandlerContext ctx) {
            NettyServerHandler.this.goAway(ctx, Integer.MAX_VALUE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii(ctx.alloc(), (CharSequence)this.goAwayMessage), ctx.newPromise());
            long gracefulShutdownPingTimeout = GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS;
            this.pingFuture = ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    GracefulShutdown.this.secondGoAwayAndClose(ctx);
                }
            }, GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
            NettyServerHandler.this.encoder().writePing(ctx, false, 40715087873L, ctx.newPromise());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void secondGoAwayAndClose(ChannelHandlerContext ctx) {
            long savedGracefulShutdownTimeMillis;
            if (this.pingAckedOrTimeout) {
                return;
            }
            this.pingAckedOrTimeout = true;
            Preconditions.checkNotNull(this.pingFuture, "pingFuture");
            this.pingFuture.cancel(false);
            NettyServerHandler.this.goAway(ctx, NettyServerHandler.this.connection().remote().lastStreamCreated(), Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii(ctx.alloc(), (CharSequence)this.goAwayMessage), ctx.newPromise());
            long gracefulShutdownTimeoutMillis = savedGracefulShutdownTimeMillis = NettyServerHandler.this.gracefulShutdownTimeoutMillis();
            if (this.graceTimeInNanos != null) {
                gracefulShutdownTimeoutMillis = TimeUnit.NANOSECONDS.toMillis(this.graceTimeInNanos);
            }
            try {
                NettyServerHandler.this.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
                NettyServerHandler.this.close(ctx, ctx.newPromise());
            }
            catch (Exception e) {
                NettyServerHandler.this.onError(ctx, true, e);
            }
            finally {
                NettyServerHandler.this.gracefulShutdownTimeoutMillis(savedGracefulShutdownTimeMillis);
            }
        }
    }

    private final class KeepAlivePinger
    implements KeepAliveManager.KeepAlivePinger {
        final ChannelHandlerContext ctx;

        KeepAlivePinger(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void ping() {
            ChannelFuture pingFuture = NettyServerHandler.this.encoder().writePing(this.ctx, false, 57005L, this.ctx.newPromise());
            this.ctx.flush();
            if (NettyServerHandler.this.transportTracer != null) {
                pingFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            NettyServerHandler.this.transportTracer.reportKeepAliveSent();
                        }
                    }
                });
            }
        }

        @Override
        public void onPingTimeout() {
            try {
                NettyServerHandler.this.forcefulClose(this.ctx, new ForcefulCloseCommand(Status.UNAVAILABLE.withDescription("Keepalive failed. The connection is likely gone")), this.ctx.newPromise());
            }
            catch (Exception ex) {
                try {
                    NettyServerHandler.this.exceptionCaught(this.ctx, ex);
                }
                catch (Exception ex2) {
                    logger.log(Level.WARNING, "Exception while propagating exception", ex2);
                    logger.log(Level.WARNING, "Original failure", ex);
                }
            }
        }
    }
}

