/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.io.BaseEncoding;
import org.glowroot.agent.shaded.io.grpc.netty.AbstractHttp2Headers;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Error;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.glowroot.agent.shaded.io.netty.util.AsciiString;
import org.glowroot.agent.shaded.io.netty.util.internal.PlatformDependent;

class GrpcHttp2HeadersUtils {

    static final class GrpcHttp2ResponseHeaders
    extends GrpcHttp2InboundHeaders {
        GrpcHttp2ResponseHeaders(int numHeadersGuess) {
            super(numHeadersGuess);
        }

        @Override
        public Http2Headers add(CharSequence csName, CharSequence csValue) {
            AsciiString name = this.validateName(GrpcHttp2ResponseHeaders.requireAsciiString(csName));
            AsciiString value = GrpcHttp2ResponseHeaders.requireAsciiString(csValue);
            return this.add(name, value);
        }

        @Override
        public CharSequence get(CharSequence csName) {
            AsciiString name = GrpcHttp2ResponseHeaders.requireAsciiString(csName);
            return this.get(name);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
            builder.append(this.namesAndValuesToString()).append(']');
            return builder.toString();
        }
    }

    static abstract class GrpcHttp2InboundHeaders
    extends AbstractHttp2Headers {
        private static final AsciiString binaryHeaderSuffix = new AsciiString("-bin".getBytes(Charsets.US_ASCII));
        private byte[][] namesAndValues;
        private AsciiString[] values;
        private int namesAndValuesIdx;

        GrpcHttp2InboundHeaders(int numHeadersGuess) {
            Preconditions.checkArgument(numHeadersGuess > 0, "numHeadersGuess needs to be gt zero.");
            this.namesAndValues = new byte[numHeadersGuess * 2][];
            this.values = new AsciiString[numHeadersGuess];
        }

        @Override
        protected Http2Headers add(AsciiString name, AsciiString value) {
            if (this.namesAndValuesIdx == this.namesAndValues.length) {
                this.expandHeadersAndValues();
            }
            byte[] nameBytes = GrpcHttp2InboundHeaders.bytes(name);
            byte[] valueBytes = GrpcHttp2InboundHeaders.toBinaryValue(name, value);
            this.values[this.namesAndValuesIdx / 2] = value;
            this.namesAndValues[this.namesAndValuesIdx] = nameBytes;
            ++this.namesAndValuesIdx;
            this.namesAndValues[this.namesAndValuesIdx] = valueBytes;
            ++this.namesAndValuesIdx;
            return this;
        }

        @Override
        protected CharSequence get(AsciiString name) {
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                if (!GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i])) continue;
                return this.values[i / 2];
            }
            return null;
        }

        @Override
        public CharSequence status() {
            return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
        }

        @Override
        public List<CharSequence> getAll(CharSequence csName) {
            AsciiString name = GrpcHttp2InboundHeaders.requireAsciiString(csName);
            ArrayList<CharSequence> returnValues = new ArrayList<CharSequence>(4);
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                if (!GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i])) continue;
                returnValues.add(this.values[i / 2]);
            }
            return returnValues;
        }

        byte[][] namesAndValues() {
            return this.namesAndValues;
        }

        protected int numHeaders() {
            return this.namesAndValuesIdx / 2;
        }

        protected static boolean equals(AsciiString str0, byte[] str1) {
            return GrpcHttp2InboundHeaders.equals(str0.array(), str0.arrayOffset(), str0.length(), str1, 0, str1.length);
        }

        protected static boolean equals(byte[] bytes0, int offset0, int length0, byte[] bytes1, int offset1, int length1) {
            if (length0 != length1) {
                return false;
            }
            return PlatformDependent.equals(bytes0, offset0, bytes1, offset1, length0);
        }

        private static byte[] toBinaryValue(AsciiString name, AsciiString value) {
            return name.endsWith(binaryHeaderSuffix) ? BaseEncoding.base64().decode(value) : GrpcHttp2InboundHeaders.bytes(value);
        }

        protected static byte[] bytes(AsciiString str) {
            return str.isEntireArrayUsed() ? str.array() : str.toByteArray();
        }

        protected static AsciiString requireAsciiString(CharSequence cs) {
            if (!(cs instanceof AsciiString)) {
                throw new IllegalArgumentException("AsciiString expected. Was: " + cs.getClass().getName());
            }
            return (AsciiString)cs;
        }

        protected AsciiString validateName(AsciiString str) {
            int offset = str.arrayOffset();
            int length = str.length();
            byte[] data = str.array();
            for (int i = offset; i < offset + length; ++i) {
                if (!AsciiString.isUpperCase(data[i])) continue;
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name '%s'", str));
            }
            return str;
        }

        private void expandHeadersAndValues() {
            int newValuesLen = Math.max(2, this.values.length + this.values.length / 2);
            int newNamesAndValuesLen = newValuesLen * 2;
            byte[][] newNamesAndValues = new byte[newNamesAndValuesLen][];
            AsciiString[] newValues = new AsciiString[newValuesLen];
            System.arraycopy(this.namesAndValues, 0, newNamesAndValues, 0, this.namesAndValues.length);
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.namesAndValues = newNamesAndValues;
            this.values = newValues;
        }

        @Override
        public int size() {
            return this.numHeaders();
        }

        protected static void appendNameAndValue(StringBuilder builder, CharSequence name, CharSequence value, boolean prependSeparator) {
            if (prependSeparator) {
                builder.append(", ");
            }
            builder.append(name).append(": ").append(value);
        }

        protected final String namesAndValuesToString() {
            StringBuilder builder = new StringBuilder();
            boolean prependSeparator = false;
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                String name = new String(this.namesAndValues[i], Charsets.US_ASCII);
                AsciiString value = this.values[i / 2];
                GrpcHttp2InboundHeaders.appendNameAndValue(builder, name, value, prependSeparator);
                prependSeparator = true;
            }
            return builder.toString();
        }
    }

    static final class GrpcHttp2ClientHeadersDecoder
    extends DefaultHttp2HeadersDecoder {
        GrpcHttp2ClientHeadersDecoder(long maxHeaderListSize) {
            super(true, maxHeaderListSize);
        }

        @Override
        protected GrpcHttp2InboundHeaders newHeaders() {
            return new GrpcHttp2ResponseHeaders(this.numberOfHeadersGuess());
        }
    }
}

