/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.io.grpc.CallOptions;
import org.glowroot.agent.shaded.io.grpc.Channel;
import org.glowroot.agent.shaded.io.grpc.ClientCall;
import org.glowroot.agent.shaded.io.grpc.ClientInterceptor;
import org.glowroot.agent.shaded.io.grpc.ClientStreamTracer;
import org.glowroot.agent.shaded.io.grpc.ForwardingClientCall;
import org.glowroot.agent.shaded.io.grpc.ForwardingClientCallListener;
import org.glowroot.agent.shaded.io.grpc.Metadata;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import org.glowroot.agent.shaded.io.opencensus.stats.MeasureMap;
import org.glowroot.agent.shaded.io.opencensus.stats.Stats;
import org.glowroot.agent.shaded.io.opencensus.stats.StatsRecorder;
import org.glowroot.agent.shaded.io.opencensus.tags.TagContext;
import org.glowroot.agent.shaded.io.opencensus.tags.TagValue;
import org.glowroot.agent.shaded.io.opencensus.tags.Tagger;
import org.glowroot.agent.shaded.io.opencensus.tags.Tags;
import org.glowroot.agent.shaded.io.opencensus.tags.propagation.TagContextBinarySerializer;
import org.glowroot.agent.shaded.io.opencensus.tags.propagation.TagContextSerializationException;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public final class CensusStatsModule {
    private static final Logger logger = Logger.getLogger(CensusStatsModule.class.getName());
    private static final double NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ClientTracer BLANK_CLIENT_TRACER = new ClientTracer();
    private final Tagger tagger;
    private final StatsRecorder statsRecorder;
    private final Supplier<Stopwatch> stopwatchSupplier;
    final Metadata.Key<TagContext> statsHeader;
    private final boolean propagateTags;

    CensusStatsModule(Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags) {
        this(Tags.getTagger(), Tags.getTagPropagationComponent().getBinarySerializer(), Stats.getStatsRecorder(), stopwatchSupplier, propagateTags);
    }

    public CensusStatsModule(final Tagger tagger, final TagContextBinarySerializer tagCtxSerializer, StatsRecorder statsRecorder, Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags) {
        this.tagger = Preconditions.checkNotNull(tagger, "tagger");
        this.statsRecorder = Preconditions.checkNotNull(statsRecorder, "statsRecorder");
        Preconditions.checkNotNull(tagCtxSerializer, "tagCtxSerializer");
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
        this.propagateTags = propagateTags;
        this.statsHeader = Metadata.Key.of("grpc-tags-bin", new Metadata.BinaryMarshaller<TagContext>(){

            @Override
            public byte[] toBytes(TagContext context) {
                try {
                    return tagCtxSerializer.toByteArray(context);
                }
                catch (TagContextSerializationException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public TagContext parseBytes(byte[] serialized) {
                try {
                    return tagCtxSerializer.fromByteArray(serialized);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse stats header", e);
                    return tagger.empty();
                }
            }
        });
    }

    ClientCallTracer newClientCallTracer(TagContext parentCtx, String fullMethodName, boolean recordStartedRpcs, boolean recordFinishedRpcs) {
        return new ClientCallTracer(this, parentCtx, fullMethodName, recordStartedRpcs, recordFinishedRpcs);
    }

    ClientInterceptor getClientInterceptor(boolean recordStartedRpcs, boolean recordFinishedRpcs) {
        return new StatsClientInterceptor(recordStartedRpcs, recordFinishedRpcs);
    }

    final class StatsClientInterceptor
    implements ClientInterceptor {
        private final boolean recordStartedRpcs;
        private final boolean recordFinishedRpcs;

        StatsClientInterceptor(boolean recordStartedRpcs, boolean recordFinishedRpcs) {
            this.recordStartedRpcs = recordStartedRpcs;
            this.recordFinishedRpcs = recordFinishedRpcs;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            TagContext parentCtx = CensusStatsModule.this.tagger.getCurrentTagContext();
            final ClientCallTracer tracerFactory = CensusStatsModule.this.newClientCallTracer(parentCtx, method.getFullMethodName(), this.recordStartedRpcs, this.recordFinishedRpcs);
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    static final class ClientCallTracer
    extends ClientStreamTracer.Factory {
        @Nullable
        private static final AtomicReferenceFieldUpdater<ClientCallTracer, ClientTracer> streamTracerUpdater;
        @Nullable
        private static final AtomicIntegerFieldUpdater<ClientCallTracer> callEndedUpdater;
        private final CensusStatsModule module;
        private final String fullMethodName;
        private final Stopwatch stopwatch;
        private volatile ClientTracer streamTracer;
        private volatile int callEnded;
        private final TagContext parentCtx;
        private final TagContext startCtx;
        private final boolean recordFinishedRpcs;

        ClientCallTracer(CensusStatsModule module, TagContext parentCtx, String fullMethodName, boolean recordStartedRpcs, boolean recordFinishedRpcs) {
            this.module = module;
            this.fullMethodName = Preconditions.checkNotNull(fullMethodName, "fullMethodName");
            this.parentCtx = Preconditions.checkNotNull(parentCtx);
            this.startCtx = module.tagger.toBuilder(parentCtx).put(RpcMeasureConstants.RPC_METHOD, TagValue.create(fullMethodName)).build();
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
            this.recordFinishedRpcs = recordFinishedRpcs;
            if (recordStartedRpcs) {
                module.statsRecorder.newMeasureMap().put(RpcMeasureConstants.RPC_CLIENT_STARTED_COUNT, 1L).record(this.startCtx);
            }
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
            ClientTracer tracer = new ClientTracer();
            if (streamTracerUpdater != null) {
                Preconditions.checkState(streamTracerUpdater.compareAndSet(this, null, tracer), "Are you creating multiple streams per call? This class doesn't yet support this case");
            } else {
                Preconditions.checkState(this.streamTracer == null, "Are you creating multiple streams per call? This class doesn't yet support this case");
                this.streamTracer = tracer;
            }
            if (this.module.propagateTags) {
                headers.discardAll(this.module.statsHeader);
                if (!this.module.tagger.empty().equals(this.parentCtx)) {
                    headers.put(this.module.statsHeader, this.parentCtx);
                }
            }
            return tracer;
        }

        void callEnded(Status status) {
            if (callEndedUpdater != null) {
                if (callEndedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.callEnded != 0) {
                    return;
                }
                this.callEnded = 1;
            }
            if (!this.recordFinishedRpcs) {
                return;
            }
            this.stopwatch.stop();
            long roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            ClientTracer tracer = this.streamTracer;
            if (tracer == null) {
                tracer = BLANK_CLIENT_TRACER;
            }
            MeasureMap measureMap = this.module.statsRecorder.newMeasureMap().put(RpcMeasureConstants.RPC_CLIENT_FINISHED_COUNT, 1L).put(RpcMeasureConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (double)roundtripNanos / NANOS_PER_MILLI).put(RpcMeasureConstants.RPC_CLIENT_REQUEST_COUNT, tracer.outboundMessageCount).put(RpcMeasureConstants.RPC_CLIENT_RESPONSE_COUNT, tracer.inboundMessageCount).put(RpcMeasureConstants.RPC_CLIENT_REQUEST_BYTES, (double)tracer.outboundWireSize).put(RpcMeasureConstants.RPC_CLIENT_RESPONSE_BYTES, (double)tracer.inboundWireSize).put(RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (double)tracer.outboundUncompressedSize).put(RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (double)tracer.inboundUncompressedSize);
            if (!status.isOk()) {
                measureMap.put(RpcMeasureConstants.RPC_CLIENT_ERROR_COUNT, 1L);
            }
            measureMap.record(this.module.tagger.toBuilder(this.startCtx).put(RpcMeasureConstants.RPC_STATUS, TagValue.create(status.getCode().toString())).build());
        }

        static {
            AtomicIntegerFieldUpdater<ClientCallTracer> tmpCallEndedUpdater;
            AtomicReferenceFieldUpdater<ClientCallTracer, ClientTracer> tmpStreamTracerUpdater;
            try {
                tmpStreamTracerUpdater = AtomicReferenceFieldUpdater.newUpdater(ClientCallTracer.class, ClientTracer.class, "streamTracer");
                tmpCallEndedUpdater = AtomicIntegerFieldUpdater.newUpdater(ClientCallTracer.class, "callEnded");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpStreamTracerUpdater = null;
                tmpCallEndedUpdater = null;
            }
            streamTracerUpdater = tmpStreamTracerUpdater;
            callEndedUpdater = tmpCallEndedUpdater;
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundUncompressedSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundUncompressedSizeUpdater;
        volatile long outboundMessageCount;
        volatile long inboundMessageCount;
        volatile long outboundWireSize;
        volatile long inboundWireSize;
        volatile long outboundUncompressedSize;
        volatile long inboundUncompressedSize;

        private ClientTracer() {
        }

        @Override
        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
        }

        @Override
        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            if (outboundUncompressedSizeUpdater != null) {
                outboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            if (inboundUncompressedSizeUpdater != null) {
                inboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundMessage(int seqNo) {
            if (inboundMessageCountUpdater != null) {
                inboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.inboundMessageCount;
            }
        }

        @Override
        public void outboundMessage(int seqNo) {
            if (outboundMessageCountUpdater != null) {
                outboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.outboundMessageCount;
            }
        }

        static {
            AtomicLongFieldUpdater<ClientTracer> tmpInboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpInboundMessageCountUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundMessageCountUpdater;
            try {
                tmpOutboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundMessageCount");
                tmpInboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundMessageCount");
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundWireSize");
                tmpOutboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundUncompressedSize");
                tmpInboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundUncompressedSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpOutboundMessageCountUpdater = null;
                tmpInboundMessageCountUpdater = null;
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
                tmpOutboundUncompressedSizeUpdater = null;
                tmpInboundUncompressedSizeUpdater = null;
            }
            outboundMessageCountUpdater = tmpOutboundMessageCountUpdater;
            inboundMessageCountUpdater = tmpInboundMessageCountUpdater;
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
            outboundUncompressedSizeUpdater = tmpOutboundUncompressedSizeUpdater;
            inboundUncompressedSizeUpdater = tmpInboundUncompressedSizeUpdater;
        }
    }
}

