/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.BinaryLog;
import org.glowroot.agent.shaded.io.grpc.ClientInterceptor;
import org.glowroot.agent.shaded.io.grpc.CompressorRegistry;
import org.glowroot.agent.shaded.io.grpc.DecompressorRegistry;
import org.glowroot.agent.shaded.io.grpc.LoadBalancer;
import org.glowroot.agent.shaded.io.grpc.ManagedChannel;
import org.glowroot.agent.shaded.io.grpc.ManagedChannelBuilder;
import org.glowroot.agent.shaded.io.grpc.NameResolver;
import org.glowroot.agent.shaded.io.grpc.NameResolverProvider;
import org.glowroot.agent.shaded.io.grpc.internal.CensusStatsModule;
import org.glowroot.agent.shaded.io.grpc.internal.CensusTracingModule;
import org.glowroot.agent.shaded.io.grpc.internal.Channelz;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransportFactory;
import org.glowroot.agent.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import org.glowroot.agent.shaded.io.grpc.internal.FixedObjectPool;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;
import org.glowroot.agent.shaded.io.grpc.internal.ManagedChannelImpl;
import org.glowroot.agent.shaded.io.grpc.internal.ManagedChannelOrphanWrapper;
import org.glowroot.agent.shaded.io.grpc.internal.ObjectPool;
import org.glowroot.agent.shaded.io.grpc.internal.OverrideAuthorityNameResolverFactory;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourcePool;
import org.glowroot.agent.shaded.io.grpc.internal.TimeProvider;
import org.glowroot.agent.shaded.io.grpc.internal.TransportTracer;
import org.glowroot.agent.shaded.io.opencensus.trace.Tracing;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final NameResolver.Factory DEFAULT_NAME_RESOLVER_FACTORY = NameResolverProvider.asFactory();
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private NameResolver.Factory nameResolverFactory = DEFAULT_NAME_RESOLVER_FACTORY;
    final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    String userAgent;
    @Nullable
    String authorityOverride;
    @Nullable
    LoadBalancer.Factory loadBalancerFactory;
    boolean fullStreamDecompression;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    int maxRetryAttempts = 5;
    int maxHedgedAttempts = 5;
    long retryBufferSize = 0x1000000L;
    long perRpcBufferLimit = 0x100000L;
    boolean retryEnabled = false;
    boolean temporarilyDisableRetry;
    Channelz channelz = Channelz.instance();
    int maxTraceEvents;
    protected TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private int maxInboundMessageSize = 0x400000;
    @Nullable
    BinaryLog binlog;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean tracingEnabled = true;
    @Nullable
    private CensusStatsModule censusStatsOverride;

    protected final int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.directServerAddress = null;
    }

    public final T executor(Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this.thisT();
    }

    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object)this.directServerAddress);
        this.nameResolverFactory = resolverFactory != null ? resolverFactory : DEFAULT_NAME_RESOLVER_FACTORY;
        return this.thisT();
    }

    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of LoadBalancer.Factory", (Object)this.directServerAddress);
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    public ManagedChannel build() {
        return new ManagedChannelOrphanWrapper(new ManagedChannelImpl(this, this.buildTransportFactory(), new ExponentialBackoffPolicy.Provider(), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.getEffectiveInterceptors(), TimeProvider.SYSTEM_TIME_PROVIDER));
    }

    final List<ClientInterceptor> getEffectiveInterceptors() {
        ArrayList<ClientInterceptor> effectiveInterceptors = new ArrayList<ClientInterceptor>(this.interceptors);
        this.temporarilyDisableRetry = false;
        if (this.statsEnabled) {
            this.temporarilyDisableRetry = true;
            CensusStatsModule censusStats = this.censusStatsOverride;
            if (censusStats == null) {
                censusStats = new CensusStatsModule(GrpcUtil.STOPWATCH_SUPPLIER, true);
            }
            effectiveInterceptors.add(0, censusStats.getClientInterceptor(this.recordStartedRpcs, this.recordFinishedRpcs));
        }
        if (this.tracingEnabled) {
            this.temporarilyDisableRetry = true;
            CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getPropagationComponent().getBinaryFormat());
            effectiveInterceptors.add(0, censusTracing.getClientInterceptor());
        }
        return effectiveInterceptors;
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    NameResolver.Factory getNameResolverFactory() {
        if (this.authorityOverride == null) {
            return this.nameResolverFactory;
        }
        return new OverrideAuthorityNameResolverFactory(this.nameResolverFactory, this.authorityOverride);
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }
}

