/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser.util;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.glowroot.agent.shaded.com.google.common.collect.BoundType;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Range;

public class RangeFactory {
    private static Method legacyRangeMethod;
    private static Method legacyDownToMethod;
    private static Method legacyUpToMethod;
    private static Method legacyAllMethod;

    private static void initLegacyRangeFactoryMethods() {
        try {
            Class<?> rangesClass = Class.forName("org.glowroot.agent.shaded.com.google.common.collect.Ranges");
            legacyRangeMethod = RangeFactory.findMethod(rangesClass, "range", Comparable.class, BoundType.class, Comparable.class, BoundType.class);
            legacyDownToMethod = RangeFactory.findMethod(rangesClass, "downTo", Comparable.class, BoundType.class);
            legacyUpToMethod = RangeFactory.findMethod(rangesClass, "upTo", Comparable.class, BoundType.class);
            legacyAllMethod = RangeFactory.findMethod(rangesClass, "all", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <C extends Comparable<?>> Range<C> range(final C lowerEndpoint, final BoundType lowerBoundType, final C upperEndpoint, final BoundType upperBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
        }, legacyRangeMethod, new Object[]{lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType});
    }

    public static <C extends Comparable<?>> Range<C> downTo(final C lowerEndpoint, final BoundType lowerBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.downTo(lowerEndpoint, lowerBoundType);
            }
        }, legacyDownToMethod, new Object[]{lowerEndpoint, lowerBoundType});
    }

    public static <C extends Comparable<?>> Range<C> upTo(final C upperEndpoint, final BoundType upperBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.upTo(upperEndpoint, upperBoundType);
            }
        }, legacyUpToMethod, new Object[]{upperEndpoint, upperBoundType});
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.all();
            }
        }, legacyAllMethod, new Object[0]);
    }

    private static <C extends Comparable<?>> Range<C> createRange(Callable<Range<C>> rangeCallable, Method legacyRangeFactoryMethod, Object ... params) {
        try {
            return rangeCallable.call();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (legacyRangeFactoryMethod != null) {
                return RangeFactory.invokeLegacyRangeFactoryMethod(legacyRangeFactoryMethod, params);
            }
            throw noSuchMethodError;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <C extends Comparable<?>> Range<C> invokeLegacyRangeFactoryMethod(Method method, Object ... params) {
        try {
            return (Range)method.invoke(null, params);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke legacy Range factory method [" + method.getName() + "] with params " + Lists.newArrayList(params) + ".", e);
        }
    }

    static {
        RangeFactory.initLegacyRangeFactoryMethods();
    }
}

