/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.CollectionType;

public abstract class GuavaCollectionDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final CollectionType _containerType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected GuavaCollectionDeserializer(CollectionType type, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(type);
        this._containerType = type;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    public abstract GuavaCollectionDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._containerType.getContentType(), property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._typeDeserializerForValue) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    @Override
    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            return this._deserializeContents(jp, ctxt);
        }
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return this._deserializeFromSingleValue(jp, ctxt);
        }
        throw ctxt.mappingException(this._containerType.getRawClass());
    }

    protected abstract T _deserializeContents(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected abstract T _deserializeFromSingleValue(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;
}

