/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext;

import java.io.Serializable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.Deserializers;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.Serializers;

public class OptionalHandlerFactory
implements Serializable {
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> rawType = type.getRawClass();
        String className = rawType.getName();
        if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
            return (JsonSerializer)this.instantiate("org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext.DOMSerializer");
        }
        if (!className.startsWith("javax.xml.") && !this.hasSupertypeStartingWith(rawType, "javax.xml.")) {
            return null;
        }
        String factoryName = "org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Serializers)ob).findSerializer(config, type, beanDesc);
    }

    public JsonDeserializer<?> findDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> rawType = type.getRawClass();
        String className = rawType.getName();
        if (!className.startsWith("javax.xml.") && !this.hasSupertypeStartingWith(rawType, "javax.xml.")) {
            if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate("org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer");
            }
            if (this.doesImplement(rawType, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate("org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer");
            }
            return null;
        }
        String factoryName = "org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Deserializers)ob).findBeanDeserializer(type, config, beanDesc);
    }

    private Object instantiate(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean doesImplement(Class<?> actualType, String classNameToImplement) {
        for (Class<?> type = actualType; type != null; type = type.getSuperclass()) {
            if (type.getName().equals(classNameToImplement)) {
                return true;
            }
            if (!this.hasInterface(type, classNameToImplement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(Class<?> type, String interfaceToImplement) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            if (!iface.getName().equals(interfaceToImplement)) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            if (!this.hasInterface(iface, interfaceToImplement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSupertypeStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        for (Class<?> cls = rawType; cls != null; cls = cls.getSuperclass()) {
            if (!this.hasInterfaceStartingWith(cls, prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterfaceStartingWith(Class<?> type, String prefix) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            if (!iface.getName().startsWith(prefix)) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            if (!this.hasInterfaceStartingWith(iface, prefix)) continue;
            return true;
        }
        return false;
    }
}

