/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet._;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.checker.MonotonicNonNull;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.servlet._.ServletMessageSupplier;

class ResponseHeaderComponent {
    private static final Logger logger = Logger.getLogger(ServletMessageSupplier.class);
    private static final SimpleDateFormat responseHeaderDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    @MonotonicNonNull
    private ConcurrentMap<String, ResponseHeader> responseHeaders;

    ResponseHeaderComponent() {
    }

    synchronized Map<String, Object> getMapOfStrings() {
        if (this.responseHeaders == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> responseHeaderStrings = new HashMap<String, Object>();
        for (ResponseHeader responseHeader : this.responseHeaders.values()) {
            String name = responseHeader.getName();
            List values = responseHeader.getValues();
            if (values != null) {
                ArrayList<String> headerValueStrings = new ArrayList<String>();
                for (Object v : values) {
                    headerValueStrings.add(ResponseHeaderComponent.headerValueString(v));
                }
                responseHeaderStrings.put(name, headerValueStrings);
                continue;
            }
            Object value = responseHeader.getValue();
            responseHeaderStrings.put(name, ResponseHeaderComponent.headerValueString(value));
        }
        return responseHeaderStrings;
    }

    synchronized void setHeader(String name, Object value) {
        String nameUpper;
        ResponseHeader responseHeader;
        if (this.responseHeaders == null) {
            this.responseHeaders = new ConcurrentHashMap<String, ResponseHeader>();
        }
        if ((responseHeader = (ResponseHeader)this.responseHeaders.get(nameUpper = name.toUpperCase(Locale.ENGLISH))) == null) {
            this.responseHeaders.put(nameUpper, new ResponseHeader(name, value));
        } else {
            responseHeader.setValue(value);
        }
    }

    synchronized void addHeader(String name, Object value) {
        String nameUpper;
        ResponseHeader responseHeader;
        if (this.responseHeaders == null) {
            this.responseHeaders = new ConcurrentHashMap<String, ResponseHeader>();
        }
        if ((responseHeader = (ResponseHeader)this.responseHeaders.get(nameUpper = name.toUpperCase(Locale.ENGLISH))) == null) {
            this.responseHeaders.put(nameUpper, new ResponseHeader(name, value));
        } else {
            responseHeader.addValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String headerValueString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            SimpleDateFormat simpleDateFormat = responseHeaderDateFormat;
            synchronized (simpleDateFormat) {
                return responseHeaderDateFormat.format(new Date((Long)value));
            }
        }
        logger.warn("unexpected value type found: {}", value);
        return "<unexpected value type: " + value.getClass() + ">";
    }

    static {
        responseHeaderDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static class ResponseHeader {
        private final String name;
        private volatile Object value;
        @MonotonicNonNull
        private volatile CopyOnWriteArrayList<Object> values;

        private ResponseHeader(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        private String getName() {
            return this.name;
        }

        private Object getValue() {
            return this.value;
        }

        @Nullable
        private List<Object> getValues() {
            return this.values;
        }

        private void setValue(Object value) {
            this.value = value;
        }

        private void addValue(Object newValue) {
            if (this.values == null) {
                this.values = new CopyOnWriteArrayList();
                this.values.add(this.value);
            }
            this.values.add(newValue);
        }
    }
}

